/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bridje.sql.Expression;
import org.bridje.sql.SQLResultSet;
import org.bridje.sql.SQLType;
import org.bridje.sql.SQLValueParser;

class SQLResultSetImpl
implements SQLResultSet {
    private final Iterator<Object[]> it;
    private Object[] current = null;
    private final List<Object[]> data = new ArrayList<Object[]>();
    private final Map<Expression<?, ?>, Integer> fieldsMap = new HashMap();

    public SQLResultSetImpl(ResultSet rs, Expression<?, ?>[] fields) throws SQLException {
        if (fields != null) {
            int index = 0;
            for (Expression<?, ?> field : fields) {
                this.fieldsMap.put(field, index);
                ++index;
            }
        }
        while (rs.next()) {
            this.data.add(this.read(rs, fields.length));
        }
        rs.close();
        this.it = this.data.iterator();
    }

    @Override
    public boolean next() throws SQLException {
        this.current = null;
        if (this.it.hasNext()) {
            this.current = this.it.next();
        }
        return this.current != null;
    }

    @Override
    public <T, E> T get(Expression<T, E> expr) throws SQLException {
        if (expr.getSQLType() == null) {
            return null;
        }
        Integer index = this.getIndex(expr);
        if (index == null) {
            return null;
        }
        return this.get(index + 1, expr.getSQLType());
    }

    @Override
    public <T, E> T get(int index, SQLType<T, E> sqlType) throws SQLException {
        Object value = this.current[index - 1];
        E readed = sqlType.read(value);
        return sqlType.parse(readed);
    }

    @Override
    public <T, E> T get(Expression<T, E> expr, SQLValueParser<T, E> parser) throws SQLException {
        Integer index = this.getIndex(expr);
        if (index != null) {
            return this.get(index + 1, expr.getSQLType(), parser);
        }
        return null;
    }

    @Override
    public <T, E> T get(int index, SQLType<T, E> sqlType, SQLValueParser<T, E> parser) throws SQLException {
        Object value = this.current[index - 1];
        if (sqlType != null) {
            E readed = sqlType.read(value);
            return parser.parse(readed);
        }
        return parser.parse(value);
    }

    @Override
    public void close() throws Exception {
    }

    private <T, E> Integer getIndex(Expression<T, E> expr) {
        if (this.fieldsMap == null) {
            return null;
        }
        return this.fieldsMap.get(expr);
    }

    private Object[] read(ResultSet rs, int cols) throws SQLException {
        Object[] result = new Object[cols];
        for (int i = 0; i < cols; ++i) {
            result[i] = rs.getObject(i + 1);
        }
        return result;
    }
}

