/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.sql.JDBCType;
import java.time.LocalDateTime;
import java.util.Date;
import org.bridje.sql.ArithmeticExpr;
import org.bridje.sql.ArrayExpr;
import org.bridje.sql.BooleanColumn;
import org.bridje.sql.BooleanExpr;
import org.bridje.sql.BuildForeignKeyStep;
import org.bridje.sql.BuildSchemaStep;
import org.bridje.sql.BuildTableStep;
import org.bridje.sql.Column;
import org.bridje.sql.DateColumn;
import org.bridje.sql.DateExpr;
import org.bridje.sql.DeleteStep;
import org.bridje.sql.Expression;
import org.bridje.sql.Index;
import org.bridje.sql.InsertIntoStep;
import org.bridje.sql.Limit;
import org.bridje.sql.NumberColumn;
import org.bridje.sql.SQLType;
import org.bridje.sql.SQLValueParser;
import org.bridje.sql.SQLValueWriter;
import org.bridje.sql.SelectStep;
import org.bridje.sql.StringColumn;
import org.bridje.sql.StringExpr;
import org.bridje.sql.Table;
import org.bridje.sql.UpdateStep;
import org.bridje.sql.impl.ArrayExprImpl;
import org.bridje.sql.impl.ColumnImpl;
import org.bridje.sql.impl.DeleteBuilder;
import org.bridje.sql.impl.ForeignKeyBuilder;
import org.bridje.sql.impl.FunctionImpl;
import org.bridje.sql.impl.IndexImpl;
import org.bridje.sql.impl.InsertBuilder;
import org.bridje.sql.impl.LimitImpl;
import org.bridje.sql.impl.LiteralImpl;
import org.bridje.sql.impl.Param;
import org.bridje.sql.impl.SQLTypeImpl;
import org.bridje.sql.impl.SchemaBuilder;
import org.bridje.sql.impl.SelectBuilder;
import org.bridje.sql.impl.SimpleExpressionImpl;
import org.bridje.sql.impl.TableBuilder;
import org.bridje.sql.impl.UpdateBuilder;

public class SQLFactory {
    private static ArithmeticExpr<Integer, Integer> COUNT_EXPR;
    private static SQLFactory INST;

    public static SQLFactory getInstance() {
        if (INST == null) {
            INST = new SQLFactory();
        }
        return INST;
    }

    private SQLFactory() {
    }

    public <T, E> SQLType<T, E> buildType(Class<T> javaType, Class<E> javaReadType, JDBCType jdbcType, int length, int precision, SQLValueParser<T, E> parser, SQLValueWriter<E, T> writer) {
        return new SQLTypeImpl<T, E>(javaType, javaReadType, jdbcType, length, precision, parser, writer);
    }

    public <T, E> SQLType<T, E> buildType(Class<T> javaType, Class<E> javaReadType, JDBCType jdbcType, int length, SQLValueParser<T, E> parser, SQLValueWriter<E, T> writer) {
        return new SQLTypeImpl<T, E>(javaType, javaReadType, jdbcType, length, 0, parser, writer);
    }

    public <T, E> SQLType<T, E> buildType(Class<T> javaType, Class<E> javaReadType, JDBCType jdbcType, SQLValueParser<T, E> parser, SQLValueWriter<E, T> writer) {
        return new SQLTypeImpl<T, E>(javaType, javaReadType, jdbcType, 0, 0, parser, writer);
    }

    public BuildSchemaStep buildSchema(String name) {
        return new SchemaBuilder(name);
    }

    public BuildTableStep buildTable(String name) {
        return new TableBuilder(name);
    }

    public <T, E> Column<T, E> buildColumn(String name, SQLType<T, E> type, boolean allowNull, T defValue) {
        return new ColumnImpl<Object, E>(name, type, allowNull, null);
    }

    public <T, E> Column<T, E> buildColumn(String name, Table table, SQLType<T, E> type, boolean allowNull, T defValue) {
        ColumnImpl<Object, E> result = new ColumnImpl<Object, E>(name, type, allowNull, null);
        result.setTable(table);
        return result;
    }

    public <T, E> NumberColumn<T, E> buildAiColumn(String name, SQLType<T, E> type, boolean allowNull) {
        ColumnImpl<Object, E> result = new ColumnImpl<Object, E>(name, type, allowNull, null);
        result.setAutoIncrement(true);
        return result;
    }

    public <T, E> NumberColumn<T, E> buildNumberColumn(String name, SQLType<T, E> type, boolean allowNull, T defValue) {
        return new ColumnImpl<T, E>(name, type, allowNull, defValue);
    }

    public <T, E> DateColumn<T, E> buildDateColumn(String name, SQLType<T, E> type, boolean allowNull, T defValue) {
        return new ColumnImpl<T, E>(name, type, allowNull, defValue);
    }

    public <T, E> StringColumn<T, E> buildStringColumn(String name, SQLType<T, E> type, boolean allowNull, T defValue) {
        return new ColumnImpl<T, E>(name, type, allowNull, defValue);
    }

    public <T, E> BooleanColumn<T, E> buildBooleanColumn(String name, SQLType<T, E> type, boolean allowNull, T defValue) {
        return new ColumnImpl<T, E>(name, type, allowNull, defValue);
    }

    public Index buildIndex(String name, Table table, Column<?, ?>[] columns) {
        return new IndexImpl(name, table, columns, false);
    }

    public Index buildIndex(Table table, Column<?, ?> ... columns) {
        return new IndexImpl(null, table, columns, false);
    }

    public Index buildUnique(String name, Table table, Column<?, ?> ... columns) {
        return new IndexImpl(name, table, columns, true);
    }

    public Index buildUnique(Table table, Column<?, ?> ... columns) {
        return new IndexImpl(null, table, columns, true);
    }

    public BuildForeignKeyStep buildForeignKey(String name, Table table, Column<?, ?>[] columns) {
        return new ForeignKeyBuilder(name, table, columns);
    }

    public BuildForeignKeyStep buildForeignKey(Table table, Column<?, ?>[] columns) {
        return new ForeignKeyBuilder(null, table, columns);
    }

    public Index buildIndex(String name, Column<?, ?>[] columns) {
        return new IndexImpl(name, null, columns, false);
    }

    public Index buildIndex(Column<?, ?> ... columns) {
        return new IndexImpl(null, null, columns, false);
    }

    public Index buildUnique(String name, Column<?, ?> ... columns) {
        return new IndexImpl(name, null, columns, true);
    }

    public Index buildUnique(Column<?, ?> ... columns) {
        return new IndexImpl(null, null, columns, true);
    }

    public BuildForeignKeyStep buildForeignKey(String name, Column<?, ?>[] columns) {
        return new ForeignKeyBuilder(name, null, columns);
    }

    public BuildForeignKeyStep buildForeignKey(Column<?, ?>[] columns) {
        return new ForeignKeyBuilder(null, null, columns);
    }

    public SelectStep select(Expression<?, ?> ... columns) {
        return new SelectBuilder(columns);
    }

    public InsertIntoStep insertInto(Table table) {
        return new InsertBuilder(table);
    }

    public UpdateStep update(Table table) {
        return new UpdateBuilder(table);
    }

    public DeleteStep delete(Table ... tables) {
        return new DeleteBuilder(tables);
    }

    public ArithmeticExpr<Number, Number> val(Number value) {
        return new LiteralImpl<Number, Number>(value);
    }

    public ArithmeticExpr<Byte, Byte> val(byte value) {
        return new LiteralImpl<Byte, Byte>(value);
    }

    public ArithmeticExpr<Byte, Byte> val(Byte value) {
        return new LiteralImpl<Byte, Byte>(value);
    }

    public ArithmeticExpr<Short, Short> val(short value) {
        return new LiteralImpl<Short, Short>(value);
    }

    public ArithmeticExpr<Short, Short> val(Short value) {
        return new LiteralImpl<Short, Short>(value);
    }

    public ArithmeticExpr<Integer, Integer> val(int value) {
        return new LiteralImpl<Integer, Integer>(value);
    }

    public ArithmeticExpr<Integer, Integer> val(Integer value) {
        return new LiteralImpl<Integer, Integer>(value);
    }

    public ArithmeticExpr<Long, Long> val(long value) {
        return new LiteralImpl<Long, Long>(value);
    }

    public ArithmeticExpr<Long, Long> val(Long value) {
        return new LiteralImpl<Long, Long>(value);
    }

    public ArithmeticExpr<Float, Float> val(float value) {
        return new LiteralImpl<Float, Float>(Float.valueOf(value));
    }

    public ArithmeticExpr<Float, Float> val(Float value) {
        return new LiteralImpl<Float, Float>(value);
    }

    public ArithmeticExpr<Double, Double> val(double value) {
        return new LiteralImpl<Double, Double>(value);
    }

    public ArithmeticExpr<Double, Double> val(Double value) {
        return new LiteralImpl<Double, Double>(value);
    }

    public StringExpr<String, String> val(String value) {
        return new LiteralImpl<String, String>(value);
    }

    public BooleanExpr<Boolean, Boolean> val(Boolean value) {
        return new LiteralImpl<Boolean, Boolean>(value);
    }

    public BooleanExpr<Boolean, Boolean> val(boolean value) {
        return new LiteralImpl<Boolean, Boolean>(value);
    }

    public Expression<Character, Character> val(char value) {
        return new LiteralImpl<Character, Character>(Character.valueOf(value));
    }

    public Expression<Character, Character> val(Character value) {
        return new LiteralImpl<Character, Character>(value);
    }

    public <T, E> ArithmeticExpr<T, E> number(T value) {
        return new LiteralImpl(value);
    }

    public <T, E> BooleanExpr<T, E> bool(T value) {
        return new LiteralImpl(value);
    }

    public <T, E> StringExpr<T, E> str(T value) {
        return new LiteralImpl(value);
    }

    public <T, E> DateExpr<T, E> date(T value) {
        return new LiteralImpl(value);
    }

    public <T, E> Expression<T, E> custom(T value) {
        return new LiteralImpl(value);
    }

    public <T, E> Expression<T, E> custom(T value, SQLType<T, E> type) {
        return new LiteralImpl<T, E>(value, type);
    }

    public <T, E> Expression<T, E> param(SQLType<T, E> cls) {
        return new Param<T, E>(cls);
    }

    public ArithmeticExpr<Integer, Integer> count() {
        if (COUNT_EXPR == null) {
            COUNT_EXPR = new SimpleExpressionImpl<Integer, Integer>("count(*)", SQLType.INTEGER);
        }
        return COUNT_EXPR;
    }

    public Limit limit(int offset, int count) {
        return new LimitImpl(offset, count);
    }

    public Limit limit(int count) {
        return new LimitImpl(count);
    }

    public <T, E> ArrayExpr<T, E> array(Expression<T, E> ... elements) {
        if (elements.length == 0) {
            return new ArrayExprImpl<T, E>(elements, null);
        }
        return new ArrayExprImpl<T, E>(elements, elements[0].getSQLType());
    }

    public <T, E> ArrayExpr<T, E> array(SQLType<T, E> type, T ... elements) {
        Expression[] result = new Expression[elements.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.custom(elements[i], type);
        }
        return this.array(result);
    }

    public DateExpr<LocalDateTime, Date> now() {
        return new FunctionImpl<LocalDateTime, Date>("NOW", SQLType.DATETIME, new Expression[0]);
    }
}

