/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import org.bridje.sql.ArithmeticExpr;
import org.bridje.sql.ArrayExpr;
import org.bridje.sql.BooleanExpr;
import org.bridje.sql.DateExpr;
import org.bridje.sql.Expression;
import org.bridje.sql.OrderExpr;
import org.bridje.sql.SQLType;
import org.bridje.sql.SortType;
import org.bridje.sql.StringExpr;
import org.bridje.sql.impl.BinaryExpr;
import org.bridje.sql.impl.FunctionImpl;
import org.bridje.sql.impl.IsNullExpr;
import org.bridje.sql.impl.LiteralImpl;
import org.bridje.sql.impl.Operators;
import org.bridje.sql.impl.OrderBy;
import org.bridje.sql.impl.UnaryExpr;

abstract class ExpressionBase<T, E>
implements BooleanExpr<T, E>,
StringExpr<T, E>,
ArithmeticExpr<T, E>,
DateExpr<T, E> {
    private final SQLType<T, E> sqlType;

    public ExpressionBase(SQLType<T, E> sqlType) {
        this.sqlType = sqlType;
    }

    @Override
    public SQLType<T, E> getSQLType() {
        return this.sqlType;
    }

    @Override
    public BooleanExpr<T, E> and(T operand) {
        return new BinaryExpr<T, E>(this, Operators.AND, new LiteralImpl<T, E>(operand, this.getSQLType()), this.getSQLType());
    }

    @Override
    public BooleanExpr<T, E> or(T operand) {
        return new BinaryExpr<T, E>(this, Operators.OR, new LiteralImpl<T, E>(operand, this.getSQLType()), this.getSQLType());
    }

    @Override
    public BooleanExpr<T, E> and(BooleanExpr<T, E> operand) {
        return new BinaryExpr<T, E>(this, Operators.AND, operand, this.getSQLType());
    }

    @Override
    public BooleanExpr<T, E> or(BooleanExpr<T, E> operand) {
        return new BinaryExpr<T, E>(this, Operators.OR, operand, this.getSQLType());
    }

    @Override
    public BooleanExpr<T, E> not() {
        return new UnaryExpr<T, E>(Operators.NOT, this, this.getSQLType());
    }

    @Override
    public BooleanExpr<Boolean, Boolean> eq(T operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.EQ, new LiteralImpl<T, E>(operand, this.getSQLType()), SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> ne(T operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.NE, new LiteralImpl<T, E>(operand, this.getSQLType()), SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> eq(Expression<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.EQ, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> ne(Expression<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.NE, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> isNull() {
        return new IsNullExpr<Boolean, Boolean>(this, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> in(ArrayExpr<T, E> array) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.IN, array, SQLType.BOOLEAN);
    }

    @Override
    public StringExpr<T, E> trim() {
        return new FunctionImpl<T, E>("trim", this.getSQLType(), this);
    }

    @Override
    public ArithmeticExpr<Integer, Integer> length() {
        return new FunctionImpl<Integer, Integer>("LENGTH", SQLType.INTEGER, this);
    }

    @Override
    public ArithmeticExpr<Integer, Integer> year() {
        return new FunctionImpl<Integer, Integer>("YEAR", SQLType.INTEGER, this);
    }

    @Override
    public ArithmeticExpr<Integer, Integer> month() {
        return new FunctionImpl<Integer, Integer>("MONTH", SQLType.INTEGER, this);
    }

    @Override
    public ArithmeticExpr<Integer, Integer> dayOfMonth() {
        return new FunctionImpl<Integer, Integer>("DAYOFMONTH", SQLType.INTEGER, this);
    }

    @Override
    public ArithmeticExpr<Integer, Integer> dayOfWeek() {
        return new FunctionImpl<Integer, Integer>("DAYOFWEEK", SQLType.INTEGER, this);
    }

    @Override
    public ArithmeticExpr<Integer, Integer> dayOfYear() {
        return new FunctionImpl<Integer, Integer>("DAYOFYEAR", SQLType.INTEGER, this);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> like(String operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.LIKE, new LiteralImpl<String, String>(operand, SQLType.STRING), SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> like(StringExpr<?, ?> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.LIKE, operand, SQLType.BOOLEAN);
    }

    @Override
    public ArithmeticExpr<T, E> plus(ArithmeticExpr<T, E> operand) {
        return new BinaryExpr<T, E>(this, Operators.PLUS, operand, this.getSQLType());
    }

    @Override
    public ArithmeticExpr<T, E> minus(ArithmeticExpr<T, E> operand) {
        return new BinaryExpr<T, E>(this, Operators.MINUS, operand, this.getSQLType());
    }

    @Override
    public ArithmeticExpr<T, E> mul(ArithmeticExpr<T, E> operand) {
        return new BinaryExpr<T, E>(this, Operators.MULT, operand, this.getSQLType());
    }

    @Override
    public ArithmeticExpr<T, E> div(ArithmeticExpr<T, E> operand) {
        return new BinaryExpr<T, E>(this, Operators.DIV, operand, this.getSQLType());
    }

    @Override
    public ArithmeticExpr<T, E> mod(ArithmeticExpr<T, E> operand) {
        return new BinaryExpr<T, E>(this, Operators.MOD, operand, this.getSQLType());
    }

    @Override
    public ArithmeticExpr<T, E> plus(T operand) {
        return new BinaryExpr<T, E>(this, Operators.PLUS, new LiteralImpl<T, E>(operand, this.getSQLType()), this.getSQLType());
    }

    @Override
    public ArithmeticExpr<T, E> minus(T operand) {
        return new BinaryExpr<T, E>(this, Operators.MINUS, new LiteralImpl<T, E>(operand, this.getSQLType()), this.getSQLType());
    }

    @Override
    public ArithmeticExpr<T, E> mul(T operand) {
        return new BinaryExpr<T, E>(this, Operators.MULT, new LiteralImpl<T, E>(operand, this.getSQLType()), this.getSQLType());
    }

    @Override
    public ArithmeticExpr<T, E> div(T operand) {
        return new BinaryExpr<T, E>(this, Operators.DIV, new LiteralImpl<T, E>(operand, this.getSQLType()), this.getSQLType());
    }

    @Override
    public ArithmeticExpr<T, E> mod(T operand) {
        return new BinaryExpr<T, E>(this, Operators.MOD, new LiteralImpl<T, E>(operand, this.getSQLType()), this.getSQLType());
    }

    @Override
    public BooleanExpr<Boolean, Boolean> gt(ArithmeticExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.GT, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> ge(ArithmeticExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.GE, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> lt(ArithmeticExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.LT, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> le(ArithmeticExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.LE, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> gt(DateExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.GT, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> ge(DateExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.GE, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> lt(DateExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.LT, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> le(DateExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.LE, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> gt(T operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.GT, new LiteralImpl<T, E>(operand, this.getSQLType()), SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> ge(T operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.GE, new LiteralImpl<T, E>(operand, this.getSQLType()), SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> lt(T operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.LT, new LiteralImpl<T, E>(operand, this.getSQLType()), SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> le(T operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.LE, new LiteralImpl<T, E>(operand, this.getSQLType()), SQLType.BOOLEAN);
    }

    @Override
    public ArithmeticExpr<Long, Long> sum() {
        return new FunctionImpl<Long, Long>("SUM", SQLType.LONG, this);
    }

    @Override
    public ArithmeticExpr<Long, Long> avg() {
        return new FunctionImpl<Long, Long>("AVG", SQLType.LONG, this);
    }

    @Override
    public ArithmeticExpr<Long, Long> count() {
        return new FunctionImpl<Long, Long>("COUNT", SQLType.LONG, this);
    }

    @Override
    public ArithmeticExpr<T, E> min() {
        return new FunctionImpl<T, E>("MIN", this.getSQLType(), this);
    }

    @Override
    public ArithmeticExpr<T, E> max() {
        return new FunctionImpl<T, E>("MAX", this.getSQLType(), this);
    }

    @Override
    public OrderExpr asc() {
        return new OrderBy(SortType.ASC, this);
    }

    @Override
    public OrderExpr desc() {
        return new OrderBy(SortType.DESC, this);
    }
}

