/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.util.ArrayList;
import java.util.List;
import org.bridje.sql.BooleanExpr;
import org.bridje.sql.Column;
import org.bridje.sql.Expression;
import org.bridje.sql.FinalStep;
import org.bridje.sql.Limit;
import org.bridje.sql.OrderExpr;
import org.bridje.sql.Query;
import org.bridje.sql.SQLBuilder;
import org.bridje.sql.SQLDialect;
import org.bridje.sql.SQLStatement;
import org.bridje.sql.SQLWritable;
import org.bridje.sql.SetsStep;
import org.bridje.sql.Table;
import org.bridje.sql.TableExpr;
import org.bridje.sql.UpdateLimitStep;
import org.bridje.sql.UpdateStep;
import org.bridje.sql.UpdateWhereStep;
import org.bridje.sql.impl.Assign;
import org.bridje.sql.impl.BuilderBase;
import org.bridje.sql.impl.Join;
import org.bridje.sql.impl.JoinType;
import org.bridje.sql.impl.LiteralImpl;
import org.bridje.sql.impl.SQLBuilderImpl;
import org.bridje.sql.impl.SQLStatementImpl;

class UpdateBuilder
extends BuilderBase
implements UpdateStep,
Query {
    private final Table table;
    private List<Join> joinsLst;
    private List<Assign<?, ?>> setsLst;
    private BooleanExpr<?, ?> where;
    private OrderExpr[] orderBys;
    private Limit limit;

    public UpdateBuilder(Table table) {
        this.table = table;
    }

    @Override
    public UpdateStep innerJoin(TableExpr table, BooleanExpr<?, ?> on) {
        if (this.joinsLst == null) {
            this.joinsLst = new ArrayList<Join>();
        }
        this.joinsLst.add(new Join(table, JoinType.INNER, on));
        return this;
    }

    @Override
    public UpdateStep leftJoin(TableExpr table, BooleanExpr<?, ?> on) {
        if (this.joinsLst == null) {
            this.joinsLst = new ArrayList<Join>();
        }
        this.joinsLst.add(new Join(table, JoinType.LEFT, on));
        return this;
    }

    @Override
    public UpdateStep rightJoin(TableExpr table, BooleanExpr<?, ?> on) {
        if (this.joinsLst == null) {
            this.joinsLst = new ArrayList<Join>();
        }
        this.joinsLst.add(new Join(table, JoinType.RIGHT, on));
        return this;
    }

    @Override
    public <T, E> SetsStep set(Column<T, E> column, T value) {
        if (this.setsLst == null) {
            this.setsLst = new ArrayList();
        }
        this.setsLst.add(new Assign<T, E>(column, new LiteralImpl(value, column.getSQLType())));
        return this;
    }

    @Override
    public <T, E> SetsStep set(Column<T, E> column, Expression<T, E> value) {
        if (this.setsLst == null) {
            this.setsLst = new ArrayList();
        }
        this.setsLst.add(new Assign<T, E>(column, value));
        return this;
    }

    @Override
    public UpdateWhereStep where(BooleanExpr<?, ?> condition) {
        this.where = condition;
        return this;
    }

    @Override
    public UpdateLimitStep orderBy(OrderExpr ... orderBys) {
        this.orderBys = orderBys;
        return this;
    }

    @Override
    public FinalStep limit(Limit limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public SQLStatement toStatement(SQLDialect dialect, Object ... parameters) {
        SQLBuilderImpl builder = new SQLBuilderImpl(dialect);
        this.writeSQL(builder);
        String sql = ((Object)builder).toString();
        return new SQLStatementImpl(null, sql, this.createParams(builder, parameters), false);
    }

    @Override
    public Query toQuery() {
        return this;
    }

    public void writeSQL(SQLBuilder builder) {
        builder.append("UPDATE ");
        builder.append(this.table);
        if (this.joinsLst != null) {
            SQLWritable[] joins = new Join[this.joinsLst.size()];
            this.joinsLst.toArray(joins);
            builder.append(' ');
            builder.appendAll(joins, " ");
        }
        if (this.setsLst != null) {
            SQLWritable[] sets = new Assign[this.setsLst.size()];
            this.setsLst.toArray(sets);
            builder.append(" SET ");
            builder.appendAll(sets, " ,");
        }
        if (this.where != null) {
            builder.append(" WHERE ");
            builder.append(this.where);
        }
        if (this.orderBys != null) {
            builder.append(" ORDER BY ");
            builder.appendAll(this.orderBys, ", ");
        }
        if (this.limit != null) {
            builder.append(this.limit);
        }
    }

    @Override
    public Expression<?, ?>[] getResultFields() {
        return null;
    }

    @Override
    public boolean isWithGeneratedKeys() {
        return false;
    }
}

