/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.sql.JDBCType;
import java.sql.SQLException;
import org.bridje.sql.Expression;
import org.bridje.sql.SQL;
import org.bridje.sql.SQLType;
import org.bridje.sql.SQLValueParser;
import org.bridje.sql.SQLValueWriter;
import org.bridje.sql.impl.CastUtils;

class SQLTypeImpl<T, E>
implements SQLType<T, E> {
    private final Class<T> javaType;
    private final Class<E> javaReadType;
    private final JDBCType jdbcType;
    private final int length;
    private final int precision;
    private SQLValueParser<T, E> parser;
    private SQLValueWriter<E, T> writer;
    private Expression<T, E> param;

    SQLTypeImpl(Class<T> javaType, Class<E> javaReadType, JDBCType jdbcType, int length, int precision, SQLValueParser<T, E> parser, SQLValueWriter<E, T> writer) {
        this.javaType = javaType;
        this.jdbcType = jdbcType;
        this.length = length;
        this.precision = precision;
        this.javaReadType = javaReadType;
        this.writer = writer;
        this.parser = parser;
    }

    SQLTypeImpl(Class<T> javaType, JDBCType jdbcType, int length, int precision, SQLValueParser<T, E> parser, SQLValueWriter<E, T> writer) {
        this(javaType, javaType, jdbcType, length, precision, parser, writer);
    }

    @Override
    public Class<T> getJavaType() {
        return this.javaType;
    }

    @Override
    public Class<E> getJavaReadType() {
        return this.javaReadType;
    }

    @Override
    public JDBCType getJDBCType() {
        return this.jdbcType;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public SQLValueParser<T, E> getParser() {
        return this.parser;
    }

    @Override
    public SQLValueWriter<E, T> getWriter() {
        return this.writer;
    }

    @Override
    public E read(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        return CastUtils.castValue(this.javaReadType, value);
    }

    @Override
    public T parse(E value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (this.parser != null) {
            return this.parser.parse(value);
        }
        return (T)value;
    }

    @Override
    public E write(T value) {
        if (value == null) {
            return null;
        }
        if (this.writer != null) {
            return this.writer.write(value);
        }
        if (this.javaReadType.isAssignableFrom(value.getClass())) {
            return (E)value;
        }
        return null;
    }

    @Override
    public Expression<T, E> asParam() {
        if (this.param == null) {
            this.param = SQL.param(this);
        }
        return this.param;
    }
}

