/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import org.bridje.sql.BuildFkFinalStep;
import org.bridje.sql.BuildFkReferencesStep;
import org.bridje.sql.BuildForeignKeyStep;
import org.bridje.sql.Column;
import org.bridje.sql.ForeignKey;
import org.bridje.sql.ForeignKeyStrategy;
import org.bridje.sql.Table;
import org.bridje.sql.impl.ForeignKeyImpl;

class ForeignKeyBuilder
implements BuildForeignKeyStep,
BuildFkReferencesStep,
BuildFkFinalStep {
    private final String name;
    private final Table table;
    private final Column<?, ?>[] columns;
    private Table referencesTable;
    private ForeignKeyStrategy onUpdate;
    private ForeignKeyStrategy onDelete;

    public ForeignKeyBuilder(String name, Table table, Column<?, ?>[] columns) {
        this.name = name;
        this.table = table;
        this.columns = columns;
    }

    @Override
    public BuildFkReferencesStep references(Table table) {
        this.referencesTable = table;
        return this;
    }

    @Override
    public BuildFkFinalStep strategy(ForeignKeyStrategy onUpdate, ForeignKeyStrategy onDelete) {
        this.onUpdate = onUpdate;
        this.onDelete = onDelete;
        return this;
    }

    @Override
    public BuildFkFinalStep strategy(ForeignKeyStrategy stategy) {
        this.onUpdate = stategy;
        this.onDelete = stategy;
        return this;
    }

    @Override
    public ForeignKey build() {
        return new ForeignKeyImpl(this.name, this.table, this.columns, this.referencesTable, this.onUpdate, this.onDelete);
    }
}

