/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import org.bridje.sql.ArithmeticExpr;
import org.bridje.sql.BooleanExpr;
import org.bridje.sql.DateExpr;
import org.bridje.sql.Expression;
import org.bridje.sql.SQLBuilder;
import org.bridje.sql.SQLType;
import org.bridje.sql.StringExpr;
import org.bridje.sql.impl.ExpressionBase;
import org.bridje.sql.impl.Operators;

class UnaryExpr<T, E>
extends ExpressionBase<T, E>
implements BooleanExpr<T, E>,
StringExpr<T, E>,
ArithmeticExpr<T, E>,
DateExpr<T, E> {
    private final Expression<?, ?> operand;
    private final Operators operator;

    public UnaryExpr(Operators operator, Expression<?, ?> operand, SQLType<T, E> type) {
        super(type);
        this.operand = operand;
        this.operator = operator;
    }

    public Expression<?, ?> getOperand() {
        return this.operand;
    }

    public Operators getOperator() {
        return this.operator;
    }

    @Override
    public void writeSQL(SQLBuilder builder) {
        builder.append('(');
        builder.append(this.operator.toSQL());
        builder.append(' ');
        builder.append(this.operand);
        builder.append(')');
    }
}

