/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.util.ArrayList;
import java.util.List;
import org.bridje.sql.BuildTableColumnsStep;
import org.bridje.sql.BuildTableFKsStep;
import org.bridje.sql.BuildTableIndexesStep;
import org.bridje.sql.BuildTableStep;
import org.bridje.sql.Column;
import org.bridje.sql.ForeignKey;
import org.bridje.sql.Index;
import org.bridje.sql.Table;
import org.bridje.sql.impl.ColumnImpl;
import org.bridje.sql.impl.TableImpl;

class TableBuilder
implements BuildTableStep {
    private final String name;
    private final List<Column<?, ?>> columns;
    private final List<Index> indexes;
    private final List<ForeignKey> foreignKeys;

    public TableBuilder(String name) {
        this.name = name;
        this.columns = new ArrayList();
        this.indexes = new ArrayList<Index>();
        this.foreignKeys = new ArrayList<ForeignKey>();
    }

    @Override
    public BuildTableStep key(Column<?, ?> column) {
        ((ColumnImpl)column).setKey(true);
        this.columns.add(column);
        return this;
    }

    @Override
    public BuildTableColumnsStep column(Column<?, ?> column) {
        ((ColumnImpl)column).setKey(false);
        this.columns.add(column);
        return this;
    }

    @Override
    public BuildTableIndexesStep index(Index index) {
        this.indexes.add(index);
        return this;
    }

    @Override
    public BuildTableFKsStep foreignKey(ForeignKey foreignKey) {
        this.foreignKeys.add(foreignKey);
        return this;
    }

    @Override
    public Table build() {
        Column[] columnsArr = new Column[this.columns.size()];
        this.columns.toArray(columnsArr);
        Index[] indexesArr = new Index[this.indexes.size()];
        this.indexes.toArray(indexesArr);
        ForeignKey[] foreignKeysArr = new ForeignKey[this.foreignKeys.size()];
        this.foreignKeys.toArray(foreignKeysArr);
        return new TableImpl(this.name, columnsArr, indexesArr, foreignKeysArr);
    }
}

