/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import org.bridje.sql.ArithmeticExpr;
import org.bridje.sql.BooleanExpr;
import org.bridje.sql.DateExpr;
import org.bridje.sql.Literal;
import org.bridje.sql.SQLBuilder;
import org.bridje.sql.SQLType;
import org.bridje.sql.StringExpr;
import org.bridje.sql.impl.BinaryExpr;
import org.bridje.sql.impl.ExpressionBase;
import org.bridje.sql.impl.Operators;

class LiteralImpl<T, E>
extends ExpressionBase<T, E>
implements BooleanExpr<T, E>,
StringExpr<T, E>,
ArithmeticExpr<T, E>,
DateExpr<T, E>,
Literal<T, E> {
    private final T value;

    public LiteralImpl(T value) {
        super(null);
        this.value = value;
    }

    public LiteralImpl(T value, SQLType<T, E> sqlType) {
        super(sqlType);
        this.value = value;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void writeSQL(SQLBuilder builder) {
        if (this.getSQLType() != null) {
            builder.getParameters().add(this.getSQLType().write(this.value));
        } else {
            builder.getParameters().add(this.value);
        }
        builder.append('?');
    }

    @Override
    public BooleanExpr<Boolean, Boolean> gt(ArithmeticExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.GT, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> ge(ArithmeticExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.GE, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> lt(ArithmeticExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.LT, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> le(ArithmeticExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.LE, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> gt(DateExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.GT, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> ge(DateExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.GE, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> lt(DateExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.LT, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> le(DateExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.LE, operand, SQLType.BOOLEAN);
    }
}

