/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.bridje.sql.SQLDialect;
import org.bridje.sql.SQLEnvironment;
import org.bridje.sql.SQLResultParser;
import org.bridje.sql.SQLStatement;
import org.bridje.sql.Schema;
import org.bridje.sql.impl.EnvironmentBase;

class EnvironmentConn
extends EnvironmentBase
implements SQLEnvironment {
    private final Connection connection;

    public EnvironmentConn(Connection connection, SQLDialect dialect) {
        super(dialect);
        this.connection = connection;
    }

    @Override
    public void fixSchema(Schema schema) throws SQLException {
        this.fixSchema(this.connection, schema);
    }

    @Override
    public void begin() throws SQLException {
        this.connection.setAutoCommit(false);
    }

    @Override
    public void commit() throws SQLException {
        this.connection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }

    @Override
    public int update(SQLStatement stmt) throws SQLException {
        return this.update(this.connection, stmt);
    }

    @Override
    public <T> List<T> fetchAll(SQLStatement stmt, SQLResultParser<T> parser) throws SQLException {
        return this.fetchAll(this.connection, stmt, parser);
    }

    @Override
    public <T> T fetchOne(SQLStatement stmt, SQLResultParser<T> parser) throws SQLException {
        return this.fetchOne(this.connection, stmt, parser);
    }
}

