/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.util.ArrayList;
import java.util.List;
import org.bridje.sql.BooleanExpr;
import org.bridje.sql.DeleteFromStep;
import org.bridje.sql.DeleteLimitStep;
import org.bridje.sql.DeleteStep;
import org.bridje.sql.DeleteWhereStep;
import org.bridje.sql.Expression;
import org.bridje.sql.FinalStep;
import org.bridje.sql.Limit;
import org.bridje.sql.OrderExpr;
import org.bridje.sql.Query;
import org.bridje.sql.SQLBuilder;
import org.bridje.sql.SQLDialect;
import org.bridje.sql.SQLStatement;
import org.bridje.sql.SQLWritable;
import org.bridje.sql.Table;
import org.bridje.sql.TableExpr;
import org.bridje.sql.impl.BuilderBase;
import org.bridje.sql.impl.Join;
import org.bridje.sql.impl.JoinType;
import org.bridje.sql.impl.SQLBuilderImpl;
import org.bridje.sql.impl.SQLStatementImpl;

class DeleteBuilder
extends BuilderBase
implements DeleteStep,
DeleteFromStep,
Query {
    private final Table[] tables;
    private TableExpr from;
    private List<Join> joinsLst;
    private BooleanExpr<?, ?> where;
    private OrderExpr[] orderBys;
    private Limit limit;

    public DeleteBuilder(Table[] tables) {
        this.tables = tables;
    }

    @Override
    public DeleteFromStep from(TableExpr table) {
        this.from = table;
        return this;
    }

    @Override
    public DeleteFromStep innerJoin(TableExpr table, BooleanExpr<?, ?> on) {
        if (this.joinsLst == null) {
            this.joinsLst = new ArrayList<Join>();
        }
        this.joinsLst.add(new Join(table, JoinType.INNER, on));
        return this;
    }

    @Override
    public DeleteFromStep leftJoin(TableExpr table, BooleanExpr<?, ?> on) {
        if (this.joinsLst == null) {
            this.joinsLst = new ArrayList<Join>();
        }
        this.joinsLst.add(new Join(table, JoinType.LEFT, on));
        return this;
    }

    @Override
    public DeleteFromStep rightJoin(TableExpr table, BooleanExpr<?, ?> on) {
        if (this.joinsLst == null) {
            this.joinsLst = new ArrayList<Join>();
        }
        this.joinsLst.add(new Join(table, JoinType.RIGHT, on));
        return this;
    }

    @Override
    public DeleteWhereStep where(BooleanExpr<?, ?> condition) {
        this.where = condition;
        return this;
    }

    @Override
    public DeleteLimitStep orderBy(OrderExpr ... orderBys) {
        this.orderBys = orderBys;
        return this;
    }

    @Override
    public FinalStep limit(Limit limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public SQLStatement toStatement(SQLDialect dialect, Object ... parameters) {
        SQLBuilderImpl builder = new SQLBuilderImpl(dialect);
        this.writeSQL(builder);
        String sql = ((Object)builder).toString();
        return new SQLStatementImpl(null, sql, this.createParams(builder, parameters), false);
    }

    @Override
    public Query toQuery() {
        return this;
    }

    public void writeSQL(SQLBuilder builder) {
        builder.append("DELETE ");
        if (this.tables != null && this.tables.length > 0) {
            builder.appendAll(this.tables, ", ");
            builder.append(" FROM ");
        } else {
            builder.append("FROM ");
        }
        builder.append(this.from);
        if (this.joinsLst != null) {
            SQLWritable[] joins = new Join[this.joinsLst.size()];
            this.joinsLst.toArray(joins);
            builder.append(' ');
            builder.appendAll(joins, " ");
        }
        if (this.where != null) {
            builder.append(" WHERE ");
            builder.append(this.where);
        }
        if (this.orderBys != null) {
            builder.append(" ORDER BY ");
            builder.appendAll(this.orderBys, ", ");
        }
        if (this.limit != null) {
            builder.append(this.limit);
        }
    }

    @Override
    public Expression<?, ?>[] getResultFields() {
        return null;
    }

    @Override
    public boolean isWithGeneratedKeys() {
        return false;
    }
}

