/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import org.bridje.sql.ArithmeticExpr;
import org.bridje.sql.BooleanExpr;
import org.bridje.sql.DateExpr;
import org.bridje.sql.Expression;
import org.bridje.sql.SQLBuilder;
import org.bridje.sql.SQLType;
import org.bridje.sql.StringExpr;
import org.bridje.sql.impl.ExpressionBase;
import org.bridje.sql.impl.Operators;

class BinaryExpr<T, E>
extends ExpressionBase<T, E>
implements BooleanExpr<T, E>,
StringExpr<T, E>,
ArithmeticExpr<T, E>,
DateExpr<T, E> {
    private final Expression<?, ?> operand1;
    private final Operators operator;
    private final Expression<?, ?> operand2;

    public BinaryExpr(Expression<?, ?> operand1, Operators operator, Expression<?, ?> operand2, SQLType<T, E> type) {
        super(type);
        this.operand1 = operand1;
        this.operator = operator;
        this.operand2 = operand2;
    }

    public Expression<?, ?> getOperand1() {
        return this.operand1;
    }

    public Operators getOperator() {
        return this.operator;
    }

    public Expression<?, ?> getOperand2() {
        return this.operand2;
    }

    @Override
    public void writeSQL(SQLBuilder builder) {
        builder.append('(');
        builder.append(this.operand1);
        builder.append(' ');
        builder.append(this.operator.toSQL());
        builder.append(' ');
        builder.append(this.operand2);
        builder.append(')');
    }
}

