/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql;

import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.bridje.sql.Expression;
import org.bridje.sql.SQL;
import org.bridje.sql.SQLValueParser;
import org.bridje.sql.SQLValueWriter;

public interface SQLType<T, E> {
    public static final SQLType<Boolean, Boolean> BOOLEAN = SQL.buildType(Boolean.class, JDBCType.BOOLEAN);
    public static final SQLType<Long, Long> LONG = SQL.buildType(Long.class, JDBCType.BIGINT);
    public static final SQLType<Integer, Integer> INTEGER = SQL.buildType(Integer.class, JDBCType.INTEGER);
    public static final SQLType<Short, Short> SHORT = SQL.buildType(Short.class, JDBCType.SMALLINT);
    public static final SQLType<Character, Character> CHAR = SQL.buildType(Character.class, JDBCType.CHAR);
    public static final SQLType<String, String> STRING = SQL.buildType(String.class, JDBCType.VARCHAR, 255);
    public static final SQLType<LocalDateTime, Date> DATETIME = SQL.buildType(LocalDateTime.class, Date.class, JDBCType.DATE, v -> LocalDateTime.ofInstant(Instant.ofEpochMilli(v.getTime()), ZoneOffset.UTC), v -> new Date(v.toInstant(ZoneOffset.UTC).toEpochMilli()));

    public Class<T> getJavaType();

    public Class<E> getJavaReadType();

    public JDBCType getJDBCType();

    public int getLength();

    public int getPrecision();

    public Expression<T, E> asParam();

    public SQLValueParser<T, E> getParser();

    public SQLValueWriter<E, T> getWriter();

    public T parse(E var1) throws SQLException;

    public E read(Object var1) throws SQLException;

    public E write(T var1);
}

