/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.sql.SQLException;

public final class CastUtils {
    protected static <F> F castValue(Class<F> fieldType, Object value) throws SQLException {
        if (value != null) {
            if (!fieldType.isAssignableFrom(value.getClass())) {
                if (Character.class.isAssignableFrom(fieldType)) {
                    return (F)CastUtils.toCharacter(value);
                }
                if (Byte.class.isAssignableFrom(fieldType)) {
                    return (F)CastUtils.toByte(value);
                }
                if (Short.class.isAssignableFrom(fieldType)) {
                    return (F)CastUtils.toShort(value);
                }
                if (Integer.class.isAssignableFrom(fieldType)) {
                    return (F)CastUtils.toInteger(value);
                }
                if (Long.class.isAssignableFrom(fieldType)) {
                    return (F)CastUtils.toLong(value);
                }
                if (Float.class.isAssignableFrom(fieldType)) {
                    return (F)CastUtils.toFloat(value);
                }
                if (Double.class.isAssignableFrom(fieldType)) {
                    return (F)CastUtils.toDouble(value);
                }
            }
            return (F)value;
        }
        return null;
    }

    private static Character toCharacter(Object value) {
        if (value instanceof String && !((String)value).isEmpty()) {
            return Character.valueOf(((String)value).toCharArray()[0]);
        }
        return null;
    }

    private static Object toByte(Object value) {
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String && !((String)value).isEmpty()) {
            return Byte.valueOf((String)value);
        }
        return null;
    }

    private static Object toShort(Object value) {
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String && !((String)value).isEmpty()) {
            return Short.valueOf((String)value);
        }
        return null;
    }

    private static Object toLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String && !((String)value).isEmpty()) {
            return Long.valueOf((String)value);
        }
        return null;
    }

    private static Object toInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String && !((String)value).isEmpty()) {
            return Integer.valueOf((String)value);
        }
        return null;
    }

    private static Object toFloat(Object value) {
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String && !((String)value).isEmpty()) {
            return Float.valueOf((String)value);
        }
        return null;
    }

    private static Object toDouble(Object value) {
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String && !((String)value).isEmpty()) {
            return Double.valueOf((String)value);
        }
        return null;
    }
}

