/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.dialects;

import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridje.ioc.Component;
import org.bridje.sql.Column;
import org.bridje.sql.ForeignKey;
import org.bridje.sql.ForeignKeyStrategy;
import org.bridje.sql.Index;
import org.bridje.sql.SQLDialect;
import org.bridje.sql.Table;

@Component
public class DerbyDialect
implements SQLDialect {
    private static final Logger LOG = Logger.getLogger(DerbyDialect.class.getName());

    @Override
    public boolean canHandle(Connection connection) {
        try {
            return connection.getMetaData().getDriverName().contains("Derby") || connection.getMetaData().getDriverName().contains("JavaDB");
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
            return false;
        }
    }

    @Override
    public void writeObjectName(StringBuilder builder, String name) {
        builder.append('\"');
        builder.append(name);
        builder.append('\"');
    }

    @Override
    public void writeLimit(StringBuilder builder, int offset, int count) {
        builder.append(" LIMIT ");
        builder.append(offset);
        if (count > 0) {
            builder.append(", ");
            builder.append(count);
        }
    }

    @Override
    public String createTable(Table table, List<Object> params) {
        Column<?, ?>[] columns;
        StringBuilder builder = new StringBuilder();
        this.createTable(builder, table);
        for (Column<?, ?> column : columns = table.getColumns()) {
            this.createColumn(builder, params, column);
        }
        this.primaryKey(builder, table.getPrimaryKey());
        return builder.toString();
    }

    @Override
    public String addColumn(Column<?, ?> column, List<Object> params) {
        StringBuilder builder = new StringBuilder();
        this.alterTable(builder, column.getTable());
        this.addColumn(builder, params, column, true);
        return builder.toString();
    }

    @Override
    public String dropColumn(Column<?, ?> column, List<Object> params) {
        StringBuilder builder = new StringBuilder();
        this.alterTable(builder, column.getTable());
        this.dropColumn(builder, column, true);
        return builder.toString();
    }

    @Override
    public String changeColumn(String oldName, Column<?, ?> column, List<Object> params) {
        StringBuilder builder = new StringBuilder();
        this.alterTable(builder, column.getTable());
        this.changeColumn(builder, params, column, oldName, true);
        return builder.toString();
    }

    @Override
    public String createIndex(Index index, List<Object> params) {
        StringBuilder builder = new StringBuilder();
        this.createIndex(builder, index.getName(), index.getTable(), index.getColumns(), index.isUnique());
        return builder.toString();
    }

    @Override
    public String dropIndex(Index index, List<Object> params) {
        StringBuilder builder = new StringBuilder();
        this.dropIndex(builder, index.getName(), index.getTable());
        return builder.toString();
    }

    @Override
    public String createForeignKey(ForeignKey fk, List<Object> params) {
        StringBuilder builder = new StringBuilder();
        this.alterTable(builder, fk.getTable());
        this.addForeignKey(builder, fk);
        return builder.toString();
    }

    @Override
    public String dropForeignKey(ForeignKey fk, List<Object> params) {
        StringBuilder builder = new StringBuilder();
        return builder.toString();
    }

    public void createTable(StringBuilder builder, Table table) {
        builder.append("CREATE TABLE ");
        this.writeObjectName(builder, table.getName());
        builder.append(" (\n");
    }

    public void createColumn(StringBuilder builder, List<Object> params, Column<?, ?> column) {
        builder.append(" ");
        this.writeObjectName(builder, column.getName());
        builder.append(" ");
        builder.append(this.createType(column));
        builder.append(this.createIsNull(column));
        builder.append(this.createDefault(column, params));
        builder.append(this.createAutoIncrement(column));
        builder.append(",\n");
    }

    public void createIndex(StringBuilder builder, String name, Table table, Column<?, ?>[] columns, boolean unique) {
        builder.append("CREATE ");
        if (unique) {
            builder.append("UNIQUE ");
        }
        builder.append("INDEX ");
        this.writeObjectName(builder, name);
        builder.append(" ON ");
        this.writeObjectName(builder, table.getName());
        builder.append(" ( ");
        this.writeColumnsNames(builder, columns, ", ");
        builder.append(" ) ");
    }

    public void createUniqueIndex(StringBuilder builder, String name, Table table, Column<?, ?>[] columns) {
        builder.append("CREATE UNIQUE INDEX ");
        this.writeObjectName(builder, name);
        builder.append(" ON ");
        this.writeObjectName(builder, table.getName());
        builder.append(" ( ");
        this.writeColumnsNames(builder, columns, ", ");
        builder.append(" ) ");
    }

    public void primaryKey(StringBuilder builder, Column<?, ?>[] columns) {
        builder.append(" PRIMARY KEY (");
        this.writeColumnsNames(builder, columns, ", ");
        builder.append(")\n)");
    }

    public void alterTable(StringBuilder builder, Table table) {
        builder.append("ALTER TABLE ");
        this.writeObjectName(builder, table.getName());
        builder.append(" \n");
    }

    public void addColumn(StringBuilder builder, List<Object> params, Column<?, ?> column, boolean isLast) {
        builder.append(" ADD COLUMN ");
        this.writeObjectName(builder, column.getName());
        builder.append(" ");
        builder.append(this.createType(column));
        builder.append(this.createIsNull(column));
        builder.append(this.createDefault(column, params));
        builder.append(this.createAutoIncrement(column));
        if (!isLast) {
            builder.append(",");
        }
        builder.append("\n");
    }

    public void dropColumn(StringBuilder builder, Column<?, ?> column, boolean isLast) {
        builder.append(" DROP COLUMN ");
        this.writeObjectName(builder, column.getName());
        if (!isLast) {
            builder.append(",");
        }
        builder.append("\n");
    }

    public void changeColumn(StringBuilder builder, List<Object> params, Column<?, ?> column, String oldColumn, boolean isLast) {
        builder.append(" CHANGE COLUMN ");
        this.writeObjectName(builder, oldColumn);
        builder.append(" ");
        this.writeObjectName(builder, column.getName());
        builder.append(" ");
        builder.append(this.createType(column));
        builder.append(this.createIsNull(column));
        builder.append(this.createDefault(column, params));
        builder.append(this.createAutoIncrement(column));
        if (!isLast) {
            builder.append(",");
        }
        builder.append("\n");
    }

    public void dropIndex(StringBuilder builder, String name, Table table) {
        builder.append(" ALTER TABLE ");
        this.writeObjectName(builder, table.getName());
        builder.append(" DROP INDEX ");
        this.writeObjectName(builder, name);
    }

    private String createType(Column<?, ?> column) {
        switch (column.getSQLType().getJDBCType()) {
            case BIT: {
                return "BOOLEAN";
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                if (column.getSQLType().getLength() <= 0) break;
                return column.getSQLType().getJDBCType().getName() + "(" + column.getSQLType().getLength() + ")";
            }
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                if (column.getSQLType().getLength() <= 0 || column.getSQLType().getPrecision() <= 0) break;
                return column.getSQLType().getJDBCType().getName() + "(" + column.getSQLType().getLength() + ", " + column.getSQLType().getPrecision() + ")";
            }
            case VARCHAR: 
            case NVARCHAR: {
                if (column.getSQLType().getLength() > 21844) {
                    return "TEXT";
                }
                if (column.getSQLType().getLength() > 65535) {
                    return "MEDIUMTEXT";
                }
                if (column.getSQLType().getLength() > 0xFFFFFF) {
                    return "LONGTEXT";
                }
                if (column.getSQLType().getLength() > 0) {
                    return "VARCHAR(" + column.getSQLType().getLength() + ")";
                }
                return "VARCHAR";
            }
            case CHAR: 
            case NCHAR: {
                if (column.getSQLType().getLength() > 0) {
                    return "CHAR(" + column.getSQLType().getLength() + ")";
                }
                return "CHAR";
            }
            case LONGNVARCHAR: 
            case LONGVARCHAR: {
                return "LONG VARCHAR";
            }
        }
        return column.getSQLType().getJDBCType().getName();
    }

    private String createIsNull(Column<?, ?> column) {
        if (column.isAllowNull() && !column.isKey()) {
            return "";
        }
        return " NOT NULL";
    }

    private String createDefault(Column<?, ?> column, List<Object> params) {
        if (column.isAutoIncrement()) {
            return "";
        }
        if (column.getDefValue() != null) {
            params.add(column.getDefValue());
            return "DEFAULT ?";
        }
        if (column.getSQLType().getJDBCType() == JDBCType.TIMESTAMP || column.getSQLType().getJDBCType() == JDBCType.TIMESTAMP_WITH_TIMEZONE) {
            return " DEFAULT '0000-00-00 00:00:00'";
        }
        return "";
    }

    private String createAutoIncrement(Column<?, ?> column) {
        if (column.isAutoIncrement()) {
            return " GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1)";
        }
        return "";
    }

    private void addForeignKey(StringBuilder builder, ForeignKey fk) {
        builder.append("ADD CONSTRAINT ");
        this.writeObjectName(builder, fk.getName());
        builder.append(" FOREIGN KEY (");
        this.writeColumnsNames(builder, fk.getColumns(), ", ");
        builder.append(") REFERENCES ");
        this.writeObjectName(builder, fk.getReferences().getName());
        builder.append(" (");
        this.writeColumnsNames(builder, fk.getReferences().getPrimaryKey(), ", ");
        if (fk.getOnDelete() != ForeignKeyStrategy.SET_DEFAULT) {
            builder.append(") ON DELETE ");
            builder.append(fk.getOnDelete().name().replace("_", " "));
        }
        if (fk.getOnUpdate() == ForeignKeyStrategy.NO_ACTION) {
            builder.append(" ON UPDATE ");
            builder.append(fk.getOnUpdate().name().replace("_", " "));
        }
    }

    private void writeColumnsNames(StringBuilder builder, Column<?, ?>[] columns, String sep) {
        boolean isFirst = true;
        for (Column<?, ?> column : columns) {
            if (!isFirst) {
                builder.append(sep);
            }
            this.writeObjectName(builder, column.getName());
            isFirst = false;
        }
    }
}

