/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.util.ArrayList;
import java.util.List;
import org.bridje.sql.SQLBuilder;
import org.bridje.sql.SQLDialect;
import org.bridje.sql.SQLWritable;

class SQLBuilderImpl
implements SQLBuilder {
    private final StringBuilder builder = new StringBuilder();
    private final List<Object> parameters = new ArrayList<Object>();
    private final SQLDialect dialect;
    private boolean simpleColumnNames;

    public SQLBuilderImpl(SQLDialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public boolean isSimpleColumnNames() {
        return this.simpleColumnNames;
    }

    @Override
    public void setSimpleColumnNames(boolean simpleColumnNames) {
        this.simpleColumnNames = simpleColumnNames;
    }

    @Override
    public SQLDialect getDialect() {
        return this.dialect;
    }

    @Override
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Override
    public SQLBuilder append(String str) {
        this.builder.append(str);
        return this;
    }

    @Override
    public SQLBuilder append(CharSequence s) {
        this.builder.append(s);
        return this;
    }

    @Override
    public SQLBuilder append(char c) {
        this.builder.append(c);
        return this;
    }

    @Override
    public SQLBuilder append(int i) {
        this.builder.append(i);
        return this;
    }

    @Override
    public SQLBuilder append(long lng) {
        this.builder.append(lng);
        return this;
    }

    @Override
    public SQLBuilder append(float f) {
        this.builder.append(f);
        return this;
    }

    @Override
    public SQLBuilder append(double d) {
        this.builder.append(d);
        return this;
    }

    @Override
    public SQLBuilder appendObjectName(String name) {
        this.dialect.writeObjectName(this.builder, name);
        return this;
    }

    @Override
    public SQLBuilder appendLimit(int offset, int count) {
        this.dialect.writeLimit(this.builder, offset, count);
        return this;
    }

    @Override
    public SQLBuilder append(SQLWritable expression) {
        expression.writeSQL(this);
        return this;
    }

    @Override
    public void appendAll(SQLWritable[] expressions, String sep) {
        boolean first = true;
        for (SQLWritable expression : expressions) {
            if (!first) {
                this.builder.append(sep);
            }
            expression.writeSQL(this);
            first = false;
        }
    }

    public String toString() {
        return this.builder.toString();
    }
}

