/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.util.ArrayList;
import java.util.List;
import org.bridje.sql.Column;
import org.bridje.sql.ColumnsStep;
import org.bridje.sql.Expression;
import org.bridje.sql.FinalStep;
import org.bridje.sql.InsertIntoStep;
import org.bridje.sql.Literal;
import org.bridje.sql.Query;
import org.bridje.sql.SQLBuilder;
import org.bridje.sql.SQLDialect;
import org.bridje.sql.SQLStatement;
import org.bridje.sql.SQLWritable;
import org.bridje.sql.SelectExpr;
import org.bridje.sql.Table;
import org.bridje.sql.ValuesStep;
import org.bridje.sql.impl.BuilderBase;
import org.bridje.sql.impl.LiteralImpl;
import org.bridje.sql.impl.Param;
import org.bridje.sql.impl.SQLBuilderImpl;
import org.bridje.sql.impl.SQLStatementImpl;

class InsertBuilder
extends BuilderBase
implements InsertIntoStep,
ColumnsStep,
ValuesStep,
FinalStep,
Query {
    private final Table table;
    private Column<?, ?>[] columns;
    private SelectExpr select;
    private List<Expression<?, ?>[]> values;

    public InsertBuilder(Table table) {
        this.table = table;
    }

    @Override
    public ColumnsStep columns(Column<?, ?> ... columns) {
        this.columns = columns;
        return this;
    }

    @Override
    public FinalStep select(SelectExpr select) {
        this.select = select;
        return this;
    }

    @Override
    public ValuesStep values(Object ... row) {
        if (this.values == null) {
            this.values = new ArrayList<Expression<?, ?>[]>();
        }
        this.values.add(this.toLiterals(row));
        return this;
    }

    @Override
    public SQLStatement toStatement(SQLDialect dialect, Object ... parameters) {
        SQLBuilderImpl builder = new SQLBuilderImpl(dialect);
        this.writeSQL(builder);
        String sql = ((Object)builder).toString();
        return new SQLStatementImpl(this.table.getAutoIncrement(), sql, this.createParams(builder, parameters), true);
    }

    @Override
    public Query toQuery() {
        return this;
    }

    @Override
    public Expression<?, ?>[] getResultFields() {
        return this.table.getAutoIncrement();
    }

    public void writeSQL(SQLBuilder builder) {
        builder.append("INSERT INTO ");
        builder.append(this.table);
        if (this.columns != null) {
            builder.append(" (");
            builder.setSimpleColumnNames(true);
            builder.appendAll(this.columns, ", ");
            builder.setSimpleColumnNames(false);
            builder.append(')');
        }
        if (this.select != null) {
            builder.append(' ');
            builder.append(this.select);
        } else if (this.values != null) {
            builder.append(" VALUES ");
            boolean first = true;
            for (SQLWritable[] sQLWritableArray : this.values) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append('(');
                builder.appendAll(sQLWritableArray, ", ");
                builder.append(") ");
            }
        }
    }

    private Expression<?, ?>[] toLiterals(Object[] row) {
        Expression[] result = new Expression[row.length];
        for (int i = 0; i < row.length; ++i) {
            Object object = row[i];
            if (object instanceof SQLWritable) {
                if (object instanceof Param || object instanceof Literal) {
                    result[i] = (Param)object;
                    continue;
                }
                throw new IllegalArgumentException("Only literals are allowed, value " + object.toString() + " is not a literal.");
            }
            result[i] = new LiteralImpl(object);
        }
        return result;
    }

    @Override
    public boolean isWithGeneratedKeys() {
        return true;
    }
}

