/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.bridje.sql.SQLDialect;
import org.bridje.sql.SQLEnvironment;
import org.bridje.sql.SQLResultParser;
import org.bridje.sql.SQLStatement;
import org.bridje.sql.Schema;
import org.bridje.sql.impl.EnvironmentBase;
import org.bridje.sql.impl.EnvironmentConn;

class EnvironmentDs
extends EnvironmentBase
implements SQLEnvironment {
    private final DataSource dataSource;
    private EnvironmentConn connEnv;

    public EnvironmentDs(DataSource dataSource, SQLDialect dialect) {
        super(dialect);
        this.dataSource = dataSource;
    }

    @Override
    public void fixSchema(Schema schema) throws SQLException {
        if (this.connEnv != null) {
            this.connEnv.fixSchema(schema);
        } else {
            try (Connection connection = this.dataSource.getConnection();){
                this.fixSchema(connection, schema);
            }
        }
    }

    @Override
    public void begin() throws SQLException {
        if (this.connEnv == null) {
            this.connEnv = new EnvironmentConn(this.dataSource.getConnection(), this.getDialect());
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.connEnv != null) {
            this.connEnv.commit();
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.connEnv != null) {
            this.connEnv.rollback();
        }
    }

    @Override
    public void close() throws Exception {
        if (this.connEnv != null) {
            this.connEnv.close();
        }
    }

    @Override
    public int update(SQLStatement stmt) throws SQLException {
        if (this.connEnv != null) {
            return this.connEnv.update(stmt);
        }
        try (Connection connection = this.dataSource.getConnection();){
            int n = this.update(connection, stmt);
            return n;
        }
    }

    @Override
    public <T> List<T> fetchAll(SQLStatement stmt, SQLResultParser<T> parser) throws SQLException {
        if (this.connEnv != null) {
            return this.connEnv.fetchAll(stmt, parser);
        }
        try (Connection connection = this.dataSource.getConnection();){
            List<T> list = this.fetchAll(connection, stmt, parser);
            return list;
        }
    }

    @Override
    public <T> T fetchOne(SQLStatement stmt, SQLResultParser<T> parser) throws SQLException {
        if (this.connEnv != null) {
            return this.connEnv.fetchOne(stmt, parser);
        }
        try (Connection connection = this.dataSource.getConnection();){
            T t = this.fetchOne(connection, stmt, parser);
            return t;
        }
    }
}

