/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import org.bridje.sql.ArithmeticExpr;
import org.bridje.sql.BooleanColumn;
import org.bridje.sql.BooleanExpr;
import org.bridje.sql.Column;
import org.bridje.sql.DateColumn;
import org.bridje.sql.DateExpr;
import org.bridje.sql.Expression;
import org.bridje.sql.NumberColumn;
import org.bridje.sql.SQLBuilder;
import org.bridje.sql.SQLType;
import org.bridje.sql.StringColumn;
import org.bridje.sql.Table;
import org.bridje.sql.impl.BinaryExpr;
import org.bridje.sql.impl.ExpressionBase;
import org.bridje.sql.impl.Operators;

class ColumnImpl<T, E>
extends ExpressionBase<T, E>
implements Column<T, E>,
NumberColumn<T, E>,
StringColumn<T, E>,
BooleanColumn<T, E>,
DateColumn<T, E> {
    private Table table;
    private final String name;
    private boolean key;
    private final boolean allowNull;
    private boolean autoIncrement;
    private final T defValue;

    public ColumnImpl(String name, SQLType<T, E> sqlType, boolean allowNull, T defValue) {
        super(sqlType);
        this.name = name;
        this.key = false;
        this.allowNull = allowNull;
        this.defValue = defValue;
        this.autoIncrement = false;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    void setTable(Table table) {
        this.table = table;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isKey() {
        return this.key;
    }

    void setKey(boolean key) {
        this.key = key;
    }

    @Override
    public boolean isAllowNull() {
        return this.allowNull;
    }

    @Override
    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    @Override
    public T getDefValue() {
        return this.defValue;
    }

    @Override
    public void writeSQL(SQLBuilder builder) {
        builder.appendObjectName(this.name);
    }

    @Override
    public Expression<T, E> asParam() {
        return this.getSQLType().asParam();
    }

    @Override
    public BooleanExpr<Boolean, Boolean> gt(ArithmeticExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.GT, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> ge(ArithmeticExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.GE, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> lt(ArithmeticExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.LT, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> le(ArithmeticExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.LE, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> gt(DateExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.GT, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> ge(DateExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.GE, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> lt(DateExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.LT, operand, SQLType.BOOLEAN);
    }

    @Override
    public BooleanExpr<Boolean, Boolean> le(DateExpr<T, E> operand) {
        return new BinaryExpr<Boolean, Boolean>(this, Operators.LE, operand, SQLType.BOOLEAN);
    }
}

