/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.bridje.ioc.Component;
import org.bridje.ioc.Inject;
import org.bridje.jdbc.JdbcService;
import org.bridje.sql.SQLDialect;
import org.bridje.sql.SQLEnvironment;
import org.bridje.sql.SQLService;
import org.bridje.sql.impl.EnvironmentConn;
import org.bridje.sql.impl.EnvironmentDs;

@Component
class SQLServiceImpl
implements SQLService {
    @Inject
    private SQLDialect[] dialects;
    @Inject
    private JdbcService jdbcServ;

    SQLServiceImpl() {
    }

    @Override
    public SQLEnvironment createEnvironment(DataSource dataSource) throws SQLException {
        try (Connection conn = dataSource.getConnection();){
            SQLDialect dialect = this.findDialect(conn);
            EnvironmentDs environmentDs = new EnvironmentDs(dataSource, dialect);
            return environmentDs;
        }
    }

    @Override
    public SQLEnvironment createEnvironment(Connection connection) throws SQLException {
        SQLDialect dialect = this.findDialect(connection);
        return new EnvironmentConn(connection, dialect);
    }

    @Override
    public SQLEnvironment createEnvironment(String dataSourceName) throws SQLException {
        return this.createEnvironment(this.jdbcServ.getDataSource(dataSourceName));
    }

    private SQLDialect findDialect(Connection connection) {
        if (connection != null) {
            for (SQLDialect d : this.dialects) {
                if (!d.canHandle(connection)) continue;
                return d;
            }
        }
        return null;
    }
}

