/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.sql.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridje.sql.Query;
import org.bridje.sql.SQLDialect;
import org.bridje.sql.SQLEnvironment;
import org.bridje.sql.SQLResultParser;
import org.bridje.sql.SQLResultSet;
import org.bridje.sql.SQLStatement;
import org.bridje.sql.Schema;
import org.bridje.sql.impl.SQLResultSetImpl;
import org.bridje.sql.impl.SchemaFixer;

abstract class EnvironmentBase
implements SQLEnvironment {
    private static final Logger LOG = Logger.getLogger(EnvironmentBase.class.getName());
    private final SQLDialect dialect;

    public EnvironmentBase(SQLDialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public SQLDialect getDialect() {
        return this.dialect;
    }

    protected void fixSchema(Connection connection, Schema schema) throws SQLException {
        new SchemaFixer(connection, this.getDialect(), schema).doFix();
    }

    @Override
    public int update(Query query, Object ... parameters) throws SQLException {
        return this.update(query.toStatement(this.getDialect(), parameters));
    }

    @Override
    public <T> List<T> fetchAll(Query query, SQLResultParser<T> parser, Object ... parameters) throws SQLException {
        return this.fetchAll(query.toStatement(this.getDialect(), parameters), parser);
    }

    @Override
    public <T> T fetchOne(Query query, SQLResultParser<T> parser, Object ... parameters) throws SQLException {
        return this.fetchOne(query.toStatement(this.getDialect(), parameters), parser);
    }

    protected int update(Connection cnn, SQLStatement sqlStmt) throws SQLException {
        LOG.log(Level.INFO, sqlStmt.getSQL());
        try (PreparedStatement stmt = this.prepareStatement(cnn, sqlStmt);){
            int n = stmt.executeUpdate();
            return n;
        }
    }

    protected <T> List<T> fetchAll(Connection cnn, SQLStatement sqlStmt, SQLResultParser<T> parser) throws SQLException {
        LOG.log(Level.INFO, sqlStmt.getSQL());
        try (PreparedStatement stmt = this.prepareStatement(cnn, sqlStmt);){
            SQLResultSetImpl rs;
            if (sqlStmt.isWithGeneratedKeys()) {
                int value = stmt.executeUpdate();
                rs = new SQLResultSetImpl(stmt.getGeneratedKeys(), sqlStmt.getResultFields());
            } else {
                rs = new SQLResultSetImpl(stmt.executeQuery(), sqlStmt.getResultFields());
            }
            List<T> list = this.fetchAll(rs, parser);
            return list;
        }
    }

    protected <T> T fetchOne(Connection cnn, SQLStatement sqlStmt, SQLResultParser<T> parser) throws SQLException {
        LOG.log(Level.INFO, sqlStmt.getSQL());
        try (PreparedStatement stmt = this.prepareStatement(cnn, sqlStmt);){
            SQLResultSetImpl rs;
            if (sqlStmt.isWithGeneratedKeys()) {
                int value = stmt.executeUpdate();
                rs = new SQLResultSetImpl(stmt.getGeneratedKeys(), sqlStmt.getResultFields());
            } else {
                rs = new SQLResultSetImpl(stmt.executeQuery(), sqlStmt.getResultFields());
            }
            T t = this.fetchOne(rs, parser);
            return t;
        }
    }

    protected PreparedStatement prepareStatement(Connection cnn, SQLStatement sqlStmt) throws SQLException {
        PreparedStatement stmt = sqlStmt.isWithGeneratedKeys() ? cnn.prepareStatement(sqlStmt.getSQL(), 1) : cnn.prepareStatement(sqlStmt.getSQL());
        Object[] params = sqlStmt.getParameters();
        for (int i = 0; i < params.length; ++i) {
            stmt.setObject(i + 1, params[i]);
        }
        return stmt;
    }

    private <T> T fetchOne(SQLResultSet rs, SQLResultParser<T> parser) throws SQLException {
        if (rs.next()) {
            return parser.parse(rs);
        }
        return null;
    }

    private <T> List<T> fetchAll(SQLResultSet rs, SQLResultParser<T> parser) throws SQLException {
        ArrayList<T> result = new ArrayList<T>();
        while (rs.next()) {
            result.add(parser.parse(rs));
        }
        return result;
    }
}

