/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.orm.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridje.ioc.Inject;
import org.bridje.ioc.Ioc;
import org.bridje.ioc.thls.Thls;
import org.bridje.ioc.thls.ThlsAction;
import org.bridje.ioc.thls.ThlsActionException;
import org.bridje.ioc.thls.ThlsActionException2;
import org.bridje.orm.EntityContext;
import org.bridje.orm.ORMEnvironment;
import org.bridje.orm.impl.EntityCache;
import org.bridje.orm.impl.EnvironmentBuilderImpl;
import org.bridje.sql.SQLEnvironment;

class ORMEnvironmentImpl
implements ORMEnvironment,
EntityContext {
    private static final Logger LOG = Logger.getLogger(ORMEnvironmentImpl.class.getName());
    private final EnvironmentBuilderImpl config;
    private final Map<Class<?>, Object> models;
    private final Map<Class<?>, EntityCache> cacheMap;
    private final Map<Class<?>, List<Field>> fieldsMap;
    private final Map<Class<?>, Constructor<?>> contructorsMap;

    public ORMEnvironmentImpl(EnvironmentBuilderImpl config) {
        this.config = config;
        this.models = new HashMap();
        this.cacheMap = new HashMap();
        this.fieldsMap = new HashMap();
        this.contructorsMap = new HashMap();
    }

    @Override
    public <T> T getModel(Class<T> modelCls) {
        Object result = this.models.get(modelCls);
        if (result == null && (result = this.createModel(modelCls)) != null) {
            this.models.put(modelCls, result);
        }
        return (T)result;
    }

    private <T> T createModel(Class<T> modelCls) {
        SQLEnvironment sqlEnv = this.config.get(modelCls);
        if (sqlEnv == null) {
            return null;
        }
        T result = this.instantiateModel(modelCls, sqlEnv);
        return result;
    }

    private <T> T instantiateModel(Class<T> modelCls, SQLEnvironment env) {
        try {
            Constructor<?> defConst = this.getDefConstructor(modelCls);
            if (defConst != null) {
                Object object = defConst.newInstance(new Object[0]);
                this.injectModels(object, env);
                return (T)object;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    @Override
    public <T> boolean contains(Class<T> entity, Object id) {
        EntityCache cache = this.cacheMap.get(entity);
        if (cache != null) {
            return cache.contains(id);
        }
        return false;
    }

    @Override
    public <T> T get(Class<T> entity, Object id) {
        EntityCache cache = this.cacheMap.get(entity);
        if (cache != null) {
            return (T)cache.get(id);
        }
        return null;
    }

    @Override
    public <T> void put(Object id, T entity) {
        if (entity == null) {
            return;
        }
        EntityCache cache = this.cacheMap.get(entity.getClass());
        if (cache == null) {
            cache = new EntityCache();
            this.cacheMap.put(entity.getClass(), cache);
        }
        cache.put(id, entity);
    }

    @Override
    public <T> void remove(Class<T> entity, Object id) {
        EntityCache cache = this.cacheMap.get(entity);
        if (cache != null) {
            cache.remove(id);
        }
    }

    @Override
    public <T> void clear(Class<T> entity) {
        EntityCache cache = this.cacheMap.get(entity);
        if (cache != null) {
            cache.clear();
        }
    }

    @Override
    public void clear() {
        this.cacheMap.clear();
    }

    private <T> void injectModels(T object, SQLEnvironment env) {
        for (Class<?> currentCls = object.getClass(); currentCls != Object.class; currentCls = currentCls.getSuperclass()) {
            List<Field> lst = this.getFieldList(currentCls);
            for (Field field : lst) {
                Object value = this.getValueForField(field, env);
                this.setFieldValue(field, object, value);
            }
        }
    }

    private List<Field> getFieldList(Class<?> cls) {
        List<Field> result = this.fieldsMap.get(cls);
        if (result == null && (result = this.findFieldList(cls)) != null) {
            this.fieldsMap.put(cls, result);
        }
        return result;
    }

    private List<Field> findFieldList(Class<?> cls) {
        Field[] fields;
        ArrayList<Field> fieldsLst = new ArrayList<Field>();
        for (Field field : fields = cls.getDeclaredFields()) {
            Inject inject = field.getAnnotation(Inject.class);
            if (inject == null) continue;
            fieldsLst.add(field);
        }
        return fieldsLst;
    }

    private Object getValueForField(Field field, SQLEnvironment env) {
        if (field.getType() == EntityContext.class) {
            return this;
        }
        if (field.getType() == SQLEnvironment.class) {
            return env;
        }
        if (this.config.contains(field.getType())) {
            return this.getModel(field.getType());
        }
        return Ioc.context().findGeneric(field.getGenericType());
    }

    private void setFieldValue(Field field, Object comp, Object value) {
        if (value != null) {
            try {
                field.setAccessible(true);
                field.set(comp, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private Constructor<?> findDefConstructor(Class<?> modelCls) {
        for (Constructor<?> constructor : modelCls.getDeclaredConstructors()) {
            constructor.setAccessible(true);
            if (constructor.getParameterTypes().length != 0) continue;
            return constructor;
        }
        return null;
    }

    private <T> Constructor<?> getDefConstructor(Class<T> modelCls) {
        Constructor<?> defConst = this.contructorsMap.get(modelCls);
        if (defConst == null && (defConst = this.findDefConstructor(modelCls)) != null) {
            this.contructorsMap.put(modelCls, defConst);
        }
        return defConst;
    }

    @Override
    public <T> T doWith(ThlsAction<T> action) {
        return (T)Thls.doAs(action, ORMEnvironment.class, (Object)this);
    }

    @Override
    public <T, E extends Throwable> T doWithEx(ThlsActionException<T, E> action) throws E {
        return (T)Thls.doAsEx(action, ORMEnvironment.class, (Object)this);
    }

    @Override
    public <T, E extends Throwable, E2 extends Throwable> T doWithEx2(ThlsActionException2<T, E, E2> action) throws E, E2 {
        return (T)Thls.doAsEx2(action, ORMEnvironment.class, (Object)this);
    }
}

