/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.orm.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.bridje.ioc.Ioc;
import org.bridje.orm.EnvironmentBuilder;
import org.bridje.orm.ORMEnvironment;
import org.bridje.orm.impl.ORMEnvironmentImpl;
import org.bridje.sql.SQLEnvironment;
import org.bridje.sql.SQLService;

class EnvironmentBuilderImpl
implements EnvironmentBuilder {
    private final Map<Class<?>, SQLEnvironment> sqlEnvironments = new HashMap();
    private final SQLService sqlServ = (SQLService)Ioc.context().find(SQLService.class);

    @Override
    public EnvironmentBuilder model(Class<?> modelClass, SQLEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException("The SQL environment must not be null.");
        }
        this.sqlEnvironments.put(modelClass, env);
        return this;
    }

    @Override
    public EnvironmentBuilder model(Class<?> modelClass, DataSource ds) throws SQLException {
        if (ds == null) {
            throw new IllegalArgumentException("The DataSource must not be null.");
        }
        this.sqlEnvironments.put(modelClass, this.createSQLEnvironment(ds));
        return this;
    }

    @Override
    public EnvironmentBuilder model(Class<?> modelClass, Connection conn) throws SQLException {
        if (conn == null) {
            throw new IllegalArgumentException("The Connection must not be null.");
        }
        this.sqlEnvironments.put(modelClass, this.createSQLEnvironment(conn));
        return this;
    }

    @Override
    public EnvironmentBuilder model(Class<?> modelClass, String dsName) throws SQLException {
        if (dsName == null) {
            throw new IllegalArgumentException("The name of the DataSource must not be null.");
        }
        this.sqlEnvironments.put(modelClass, this.createSQLEnvironment(dsName));
        return this;
    }

    @Override
    public EnvironmentBuilder modelBySchema(Class<?> modelClass, String schemaName) throws SQLException {
        if (schemaName == null) {
            throw new IllegalArgumentException("The name of the schema must not be null.");
        }
        this.sqlEnvironments.put(modelClass, this.createSQLEnvironmentBySchema(schemaName));
        return this;
    }

    public SQLEnvironment get(Class<?> modelClass) {
        return this.sqlEnvironments.get(modelClass);
    }

    private SQLEnvironment createSQLEnvironment(DataSource ds) throws SQLException {
        return this.sqlServ.createEnvironment(ds);
    }

    private SQLEnvironment createSQLEnvironment(Connection conn) throws SQLException {
        return this.sqlServ.createEnvironment(conn);
    }

    private SQLEnvironment createSQLEnvironment(String dsName) throws SQLException {
        return this.sqlServ.createEnvironment(dsName);
    }

    private SQLEnvironment createSQLEnvironmentBySchema(String schenmaName) throws SQLException {
        return this.sqlServ.createEnvironmentBySchema(schenmaName);
    }

    public boolean contains(Class<?> type) {
        return this.sqlEnvironments.containsKey(type);
    }

    @Override
    public ORMEnvironment build() {
        return new ORMEnvironmentImpl(this);
    }
}

