/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.orm;

import java.util.Arrays;
import java.util.List;
import org.bridje.orm.Page;
import org.bridje.sql.Limit;
import org.bridje.sql.SQL;

public class Paging {
    private final int recordCount;
    private final int pageSize;
    private Page[] pages;
    private int current;
    private int pageCount;

    private Paging(int count, int size) {
        this.recordCount = count;
        this.pageSize = size;
        this.pageCount = count / size;
        if (count == 0 || count % size != 0) {
            ++this.pageCount;
        }
        this.setCurrent(1);
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Page[] getPages() {
        if (this.pages == null) {
            this.pages = new Page[this.pageCount];
            for (int i = 0; i < this.pageCount; ++i) {
                this.pages[i] = Page.of(i + 1);
            }
        }
        return this.pages;
    }

    public Page[] getPagesSection(int sectionSize) {
        if (sectionSize >= this.getPages().length) {
            return this.getPages();
        }
        if (sectionSize <= 0) {
            return new Page[0];
        }
        Page[] section = new Page[sectionSize];
        int halfSectionSize = sectionSize / 2;
        int start = 0;
        start = Math.max(start, this.current - halfSectionSize);
        start = Math.min(start, this.pages.length - sectionSize);
        for (int i = 0; i < sectionSize; ++i) {
            int idx = start + i;
            section[i] = this.pages[idx];
        }
        return section;
    }

    public List<Page> getPagesAsList() {
        return Arrays.asList(this.getPages());
    }

    public List<Page> getPagesSectionAsList(int sectionSize) {
        return Arrays.asList(this.getPagesSection(sectionSize));
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public Page getCurrent() {
        if (this.pages == null) {
            return Page.of(this.current);
        }
        return this.pages[this.current - 1];
    }

    public void setCurrent(Page current) {
        this.current = current.getValue();
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public void next() {
        if (!this.isLast()) {
            this.setCurrent(this.current + 1);
        }
    }

    public void prev() {
        if (!this.isFirst()) {
            this.setCurrent(this.current - 1);
        }
    }

    public boolean isFirst() {
        return this.current == 1;
    }

    public boolean isLast() {
        return this.current == this.pageCount;
    }

    public Page getPage(int value) {
        if (this.pageCount == 0) {
            return null;
        }
        if (value <= 0) {
            return this.pages[0];
        }
        this.getPages();
        if (value > this.pageCount) {
            return this.pages[this.pageCount - 1];
        }
        return this.pages[value - 1];
    }

    public static Paging of(int count, int size) {
        if (count <= 0 && size <= 0) {
            return null;
        }
        return new Paging(count, size);
    }

    public static Paging of(int count, int size, int current) {
        if (count <= 0 && size <= 0) {
            return null;
        }
        Paging paging = new Paging(count, size);
        paging.setCurrent(current);
        return paging;
    }

    public String toString() {
        return this.recordCount + ":" + this.pageSize + ":" + this.current;
    }

    public static Paging fromString(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        String[] arr = value.split(":");
        Integer count = Integer.valueOf(arr[0]);
        Integer size = Integer.valueOf(arr[1]);
        Integer current = Integer.valueOf(arr[2]);
        return Paging.of(count, size, current);
    }

    public Limit toLimit() {
        return SQL.limit((int)((this.current - 1) * this.pageSize), (int)this.pageSize);
    }
}

