/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.jfx.binding;

import java.lang.ref.WeakReference;
import java.util.Set;
import javafx.beans.WeakListener;
import javafx.collections.SetChangeListener;
import org.bridje.jfx.binding.ContentConverter;

public class SetContentBinding<E, T>
implements SetChangeListener<E>,
WeakListener {
    private final WeakReference<Set<T>> setRef;
    private final ContentConverter<E, T> converter;

    public SetContentBinding(Set<T> set, ContentConverter<E, T> converter) {
        this.setRef = new WeakReference<Set<Set<T>>>(set);
        this.converter = converter;
    }

    public void onChanged(SetChangeListener.Change<? extends E> change) {
        Set set = (Set)this.setRef.get();
        if (set == null) {
            change.getSet().removeListener((SetChangeListener)this);
        } else if (change.wasRemoved()) {
            set.remove(this.converter.convert(change.getElementRemoved()));
        } else {
            set.add(this.converter.convert(change.getElementAdded()));
        }
    }

    public boolean wasGarbageCollected() {
        return this.setRef.get() == null;
    }

    public int hashCode() {
        Set set = (Set)this.setRef.get();
        return set == null ? 0 : set.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Set set1 = (Set)this.setRef.get();
        if (set1 == null) {
            return false;
        }
        if (obj instanceof SetContentBinding) {
            SetContentBinding other = (SetContentBinding)obj;
            Set set2 = (Set)other.setRef.get();
            return set1 == set2;
        }
        return false;
    }
}

