/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.jfx.binding;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.WeakListener;
import javafx.collections.ListChangeListener;
import org.bridje.jfx.binding.ContentConverter;

public class ListContentBinding<E, T>
implements ListChangeListener<E>,
WeakListener {
    private final WeakReference<List<T>> listRef;
    private final ContentConverter<E, T> converter;

    public ListContentBinding(List<T> list, ContentConverter<E, T> converter) {
        this.listRef = new WeakReference<List<List<T>>>(list);
        this.converter = converter;
    }

    public void onChanged(ListChangeListener.Change<? extends E> change) {
        List list = (List)this.listRef.get();
        if (list == null) {
            change.getList().removeListener((ListChangeListener)this);
        } else {
            while (change.next()) {
                if (change.wasPermutated()) {
                    list.subList(change.getFrom(), change.getTo()).clear();
                    list.addAll(change.getFrom(), this.convert(change.getList().subList(change.getFrom(), change.getTo())));
                    continue;
                }
                if (change.wasRemoved()) {
                    list.subList(change.getFrom(), change.getFrom() + change.getRemovedSize()).clear();
                }
                if (!change.wasAdded()) continue;
                list.addAll(change.getFrom(), this.convert(change.getAddedSubList()));
            }
        }
    }

    public boolean wasGarbageCollected() {
        return this.listRef.get() == null;
    }

    public int hashCode() {
        List list = (List)this.listRef.get();
        return list == null ? 0 : list.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        List list1 = (List)this.listRef.get();
        if (list1 == null) {
            return false;
        }
        if (obj instanceof ListContentBinding) {
            ListContentBinding other = (ListContentBinding)obj;
            List list2 = (List)other.listRef.get();
            return list1 == list2;
        }
        return false;
    }

    private Collection<? extends T> convert(List<? extends E> subList) {
        return subList.stream().map(this.converter::convert).collect(Collectors.toList());
    }
}

