/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.jfx.binding;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import org.bridje.jfx.binding.ContentConverter;
import org.bridje.jfx.binding.ListContentBinding;
import org.bridje.jfx.binding.SetContentBinding;

class ExContentBinding {
    ExContentBinding() {
    }

    private static void checkParameters(Object property1, Object property2) {
        if (property1 == null || property2 == null) {
            throw new NullPointerException("Both parameters must be specified.");
        }
        if (property1.equals(property2)) {
            throw new IllegalArgumentException("Cannot bind object to itself");
        }
    }

    public static <E, T> Object bind(List<T> list1, ObservableList<? extends E> list2, ContentConverter<E, T> converter) {
        ExContentBinding.checkParameters(list1, list2);
        ListContentBinding<E, T> contentBinding = new ListContentBinding<E, T>(list1, converter);
        if (list1 instanceof ObservableList) {
            ((ObservableList)list1).setAll(list2);
        } else {
            list1.clear();
            list1.addAll(ExContentBinding.convert(list2, converter));
        }
        list2.removeListener(contentBinding);
        list2.addListener(contentBinding);
        return contentBinding;
    }

    public static void unbind(Object obj1, Object obj2) {
        ExContentBinding.checkParameters(obj1, obj2);
        if (obj1 instanceof List && obj2 instanceof ObservableList) {
            ((ObservableList)obj2).removeListener(new ListContentBinding((List)obj1, null));
        } else if (obj1 instanceof Set && obj2 instanceof ObservableSet) {
            ((ObservableSet)obj2).removeListener(new SetContentBinding((Set)obj1, null));
        }
    }

    private static <E, T> Collection<? extends T> convert(List<? extends E> subList, ContentConverter<E, T> converter) {
        return subList.stream().map(converter::convert).collect(Collectors.toList());
    }
}

