/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.jfx.binding;

import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import org.bridje.jfx.binding.BiContentConverter;
import org.bridje.jfx.binding.BiListContentBinding;
import org.bridje.jfx.binding.BiSetContentBinding;

class ExBiContentBinding {
    ExBiContentBinding() {
    }

    private static void checkParameters(Object property1, Object property2) {
        if (property1 == null || property2 == null) {
            throw new NullPointerException("Both parameters must be specified.");
        }
        if (property1 == property2) {
            throw new IllegalArgumentException("Cannot bind object to itself");
        }
    }

    public static <E, T> Object bind(ObservableList<E> list1, ObservableList<T> list2, BiContentConverter<E, T> converter) {
        ExBiContentBinding.checkParameters(list1, list2);
        BiListContentBinding<E, T> binding = new BiListContentBinding<E, T>(list1, list2, converter);
        list1.setAll(ExBiContentBinding.convertTo(list2, converter));
        list1.addListener(binding);
        list2.addListener(binding);
        return binding;
    }

    public static void unbind(Object obj1, Object obj2) {
        ExBiContentBinding.checkParameters(obj1, obj2);
        if (obj1 instanceof ObservableList && obj2 instanceof ObservableList) {
            ObservableList list1 = (ObservableList)obj1;
            ObservableList list2 = (ObservableList)obj2;
            BiListContentBinding binding = new BiListContentBinding(list1, list2, null);
            list1.removeListener(binding);
            list2.removeListener(binding);
        } else if (obj1 instanceof ObservableSet && obj2 instanceof ObservableSet) {
            ObservableSet set1 = (ObservableSet)obj1;
            ObservableSet set2 = (ObservableSet)obj2;
            BiSetContentBinding binding = new BiSetContentBinding(set1, set2, null);
            set1.removeListener(binding);
            set2.removeListener(binding);
        }
    }

    private static <E, T> List<E> convertTo(List<T> subList, BiContentConverter<E, T> converter) {
        return subList.stream().map(converter::convertTo).collect(Collectors.toList());
    }
}

