/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.jfx.binding;

import java.lang.ref.WeakReference;
import javafx.beans.WeakListener;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import org.bridje.jfx.binding.BiContentConverter;

public class BiSetContentBinding<E, T>
implements SetChangeListener<Object>,
WeakListener {
    private final WeakReference<ObservableSet<E>> propertyRef1;
    private final WeakReference<ObservableSet<T>> propertyRef2;
    private boolean updating = false;
    private final BiContentConverter<E, T> converter;

    public BiSetContentBinding(ObservableSet<E> set1, ObservableSet<T> set2, BiContentConverter<E, T> converter) {
        this.propertyRef1 = new WeakReference<ObservableSet<E>>(set1);
        this.propertyRef2 = new WeakReference<ObservableSet<ObservableSet<T>>>(set2);
        this.converter = converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChanged(SetChangeListener.Change<? extends Object> change) {
        if (!this.updating) {
            ObservableSet set1 = (ObservableSet)this.propertyRef1.get();
            ObservableSet set2 = (ObservableSet)this.propertyRef2.get();
            if (set1 == null || set2 == null) {
                if (set1 != null) {
                    set1.removeListener((SetChangeListener)this);
                }
                if (set2 != null) {
                    set2.removeListener((SetChangeListener)this);
                }
            } else {
                try {
                    this.updating = true;
                    if (change.wasRemoved()) {
                        if (set1 == change.getSet()) {
                            set2.remove(this.converter.convertFrom(change.getElementRemoved()));
                        } else {
                            set1.remove(this.converter.convertTo(change.getElementRemoved()));
                        }
                    } else if (set1 == change.getSet()) {
                        set2.add(this.converter.convertFrom(change.getElementAdded()));
                    } else {
                        set1.add(this.converter.convertTo(change.getElementAdded()));
                    }
                }
                finally {
                    this.updating = false;
                }
            }
        }
    }

    public boolean wasGarbageCollected() {
        return this.propertyRef1.get() == null || this.propertyRef2.get() == null;
    }

    public int hashCode() {
        ObservableSet set1 = (ObservableSet)this.propertyRef1.get();
        ObservableSet set2 = (ObservableSet)this.propertyRef2.get();
        int hc1 = set1 == null ? 0 : set1.hashCode();
        int hc2 = set2 == null ? 0 : set2.hashCode();
        return hc1 * hc2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Object propertyA1 = this.propertyRef1.get();
        Object propertyA2 = this.propertyRef2.get();
        if (propertyA1 == null || propertyA2 == null) {
            return false;
        }
        if (obj instanceof BiSetContentBinding) {
            BiSetContentBinding otherBinding = (BiSetContentBinding)obj;
            Object propertyB1 = otherBinding.propertyRef1.get();
            Object propertyB2 = otherBinding.propertyRef2.get();
            if (propertyB1 == null || propertyB2 == null) {
                return false;
            }
            if (propertyA1 == propertyB1 && propertyA2 == propertyB2) {
                return true;
            }
            return propertyA1 == propertyB2 && propertyA2 == propertyB1;
        }
        return false;
    }
}

