/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.jfx.binding;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.WeakListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.bridje.jfx.binding.BiContentConverter;

public class BiListContentBinding<E, T>
implements ListChangeListener,
WeakListener {
    private final WeakReference<ObservableList<E>> propertyRef1;
    private final WeakReference<ObservableList<T>> propertyRef2;
    private boolean updating = false;
    private final BiContentConverter<E, T> converter;

    public BiListContentBinding(ObservableList<E> list1, ObservableList<T> list2, BiContentConverter<E, T> converter) {
        this.propertyRef1 = new WeakReference<ObservableList<E>>(list1);
        this.propertyRef2 = new WeakReference<ObservableList<ObservableList<T>>>(list2);
        this.converter = converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChanged(ListChangeListener.Change change) {
        if (!this.updating) {
            ObservableList list1 = (ObservableList)this.propertyRef1.get();
            ObservableList list2 = (ObservableList)this.propertyRef2.get();
            if (list1 == null || list2 == null) {
                if (list1 != null) {
                    list1.removeListener((ListChangeListener)this);
                }
                if (list2 != null) {
                    list2.removeListener((ListChangeListener)this);
                }
            } else {
                try {
                    ObservableList dest;
                    this.updating = true;
                    ObservableList observableList = dest = list1 == change.getList() ? list2 : list1;
                    while (change.next()) {
                        if (change.wasPermutated()) {
                            dest.remove(change.getFrom(), change.getTo());
                            if (list1 == change.getList()) {
                                list2.addAll(change.getFrom(), this.convertFrom(list1.subList(change.getFrom(), change.getTo())));
                                continue;
                            }
                            list1.addAll(change.getFrom(), this.convertTo(list2.subList(change.getFrom(), change.getTo())));
                            continue;
                        }
                        if (change.wasRemoved()) {
                            dest.remove(change.getFrom(), change.getFrom() + change.getRemovedSize());
                        }
                        if (!change.wasAdded()) continue;
                        if (list1 == change.getList()) {
                            list2.addAll(change.getFrom(), this.convertFrom(change.getAddedSubList()));
                            continue;
                        }
                        list1.addAll(change.getFrom(), this.convertTo(change.getAddedSubList()));
                    }
                }
                finally {
                    this.updating = false;
                }
            }
        }
    }

    public boolean wasGarbageCollected() {
        return this.propertyRef1.get() == null || this.propertyRef2.get() == null;
    }

    public int hashCode() {
        ObservableList list1 = (ObservableList)this.propertyRef1.get();
        ObservableList list2 = (ObservableList)this.propertyRef2.get();
        int hc1 = list1 == null ? 0 : list1.hashCode();
        int hc2 = list2 == null ? 0 : list2.hashCode();
        return hc1 * hc2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Object propertyA1 = this.propertyRef1.get();
        Object propertyA2 = this.propertyRef2.get();
        if (propertyA1 == null || propertyA2 == null) {
            return false;
        }
        if (obj instanceof BiListContentBinding) {
            BiListContentBinding otherBinding = (BiListContentBinding)obj;
            Object propertyB1 = otherBinding.propertyRef1.get();
            Object propertyB2 = otherBinding.propertyRef2.get();
            if (propertyB1 == null || propertyB2 == null) {
                return false;
            }
            if (propertyA1 == propertyB1 && propertyA2 == propertyB2) {
                return true;
            }
            if (propertyA1 == propertyB2 && propertyA2 == propertyB1) {
                return true;
            }
        }
        return false;
    }

    private List<T> convertFrom(List<E> subList) {
        return subList.stream().map(this.converter::convertFrom).collect(Collectors.toList());
    }

    private List<E> convertTo(List<T> subList) {
        return subList.stream().map(this.converter::convertTo).collect(Collectors.toList());
    }
}

