/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.jfx.ace;

import java.util.Map;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import netscape.javascript.JSObject;
import org.bridje.jfx.ace.AceEditor;

public final class AceJsGate {
    private final AceEditor editor;
    private final JSObject js;

    public AceJsGate(AceEditor editor, JSObject js) {
        this.editor = editor;
        this.js = js;
        this.js.setMember("java", this);
    }

    public void textChanged(String text) {
        this.editor.setTextFromJs(text);
    }

    public String findReplace(String text) {
        if (this.editor.getReplaceHandler() != null) {
            return text;
        }
        String replace = this.editor.getReplaceHandler().replace(text);
        return replace;
    }

    public void copyToClipboard(String text) {
        ClipboardContent content = new ClipboardContent();
        content.putString(text);
        Clipboard clipboard = Clipboard.getSystemClipboard();
        clipboard.setContent((Map)content);
    }

    public String getClipboardContent() {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        return String.valueOf(clipboard.getContent(DataFormat.PLAIN_TEXT));
    }

    public Object exec(String method, Object ... args) {
        if (this.js != null) {
            return this.js.call(method, args);
        }
        return null;
    }
}

