/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.jfx.ace;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import netscape.javascript.JSObject;
import org.bridje.jfx.ace.AceJsGate;
import org.bridje.jfx.ace.AceMode;
import org.bridje.jfx.ace.AceReadyListener;
import org.bridje.jfx.ace.AceReplaceHandler;

public final class AceEditor
extends VBox {
    private static final Logger LOG = Logger.getLogger(AceEditor.class.getName());
    private final ObjectProperty<ContextMenu> contextMenuProperty = new SimpleObjectProperty();
    private final SimpleStringProperty textProperty = new SimpleStringProperty("");
    private AceJsGate gate;
    private AceReadyListener readyListener;
    private final ChangeListener<String> listener;
    private AceReplaceHandler replaceHandler;

    public AceEditor(AceMode mode) {
        WebView editor = new WebView();
        this.loadContent(editor, mode);
        this.getChildren().add((Object)editor);
        this.contextMenuProperty.addListener((observable, oldValue, newValue) -> {
            editor.setContextMenuEnabled(false);
            editor.setOnContextMenuRequested(e -> newValue.show((Node)editor, e.getScreenX(), e.getScreenY()));
        });
        this.setContextMenu(this.createDefaultContextMenu());
        this.listener = (observable, oldValue, newValue) -> this.updateEditorContent((String)newValue);
        this.textProperty().addListener(this.listener);
    }

    public final void onReady(AceReadyListener listener) {
        this.readyListener = listener;
    }

    public String findSelection() {
        Object raw;
        if (this.gate != null && (raw = this.gate.exec("editorSelected", new Object[0])) != null) {
            return raw.toString();
        }
        return "";
    }

    public void replaceSelection(String text) {
        if (this.gate != null) {
            this.gate.exec("editorReplaceSelected", text);
        }
    }

    public void searchAndReplace(String oldValue, String newValue) {
        if (this.gate != null) {
            this.gate.exec("editorSearchAndReplace", oldValue, newValue);
        }
    }

    public ObjectProperty<ContextMenu> contextMenuProperty() {
        return this.contextMenuProperty;
    }

    public ContextMenu getContextMenu() {
        return (ContextMenu)this.contextMenuProperty.get();
    }

    public void setContextMenu(ContextMenu value) {
        this.contextMenuProperty.set((Object)value);
    }

    public void onReplace(AceReplaceHandler handler) {
        this.replaceHandler = handler;
    }

    public SimpleStringProperty textProperty() {
        return this.textProperty;
    }

    public String getText() {
        return this.textProperty.get();
    }

    public void setText(String text) {
        this.textProperty.set(text);
    }

    private ContextMenu createDefaultContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getItems().addAll((Object[])new MenuItem[]{this.gateExecMenuItem("Cut", "editorCut"), this.gateExecMenuItem("Copy", "editorCopy"), this.gateExecMenuItem("Paste", "editorPaste"), this.gateExecMenuItem("Replace...", "editorReplace")});
        return contextMenu;
    }

    private MenuItem gateExecMenuItem(String title, String command) {
        MenuItem mi = new MenuItem(title);
        mi.setOnAction(event -> this.gateExec(command));
        return mi;
    }

    private void gateExec(String command) {
        if (this.gate != null) {
            this.gate.exec(command, new Object[0]);
        }
    }

    private void updateEditorContent(String text) {
        String realText = text;
        if (realText == null) {
            realText = "";
        }
        this.gate.exec("editorContent", realText);
    }

    protected void setTextFromJs(String text) {
        this.textProperty().removeListener(this.listener);
        this.setText(text);
        this.textProperty().addListener(this.listener);
    }

    private void loadContent(WebView editor, AceMode aceMode) {
        AceMode mode = aceMode;
        WebEngine engine = editor.getEngine();
        if (mode == null) {
            mode = AceMode.JAVA;
        }
        String strMode = "var mode = 'VALUE';\n{{mode-VALUE.js}}".replaceAll("VALUE", mode.name().toLowerCase());
        engine.loadContent(AceEditor.readContent("ace.html", true, strMode));
        engine.getLoadWorker().stateProperty().addListener((observable, oldState, newState) -> {
            switch (newState) {
                case SUCCEEDED: {
                    JSObject js = (JSObject)engine.executeScript("window");
                    this.gate = new AceJsGate(this, js);
                    if (this.readyListener == null) break;
                    this.readyListener.ready();
                    break;
                }
            }
        });
    }

    private static String readContent(String resource, boolean replace, String mode) {
        InputStream stream = AceEditor.class.getResourceAsStream(resource);
        if (stream != null) {
            BufferedReader buf = new BufferedReader(new InputStreamReader(stream));
            StringBuilder builder = new StringBuilder();
            try {
                String line = buf.readLine();
                while (line != null) {
                    if (mode != null) {
                        line = line.replace("[[MODE]]", mode);
                    }
                    if (replace) {
                        line = AceEditor.doReplace(line);
                    }
                    builder.append(line).append("\n");
                    line = buf.readLine();
                }
            }
            catch (IOException ignored) {
                LOG.log(Level.SEVERE, ignored.getMessage(), ignored);
            }
            return builder.toString();
        }
        return "";
    }

    private static String doReplace(String line) {
        int startIndex = line.indexOf("{{");
        if (startIndex < 0) {
            return line;
        }
        int endIndex = line.indexOf("}}", startIndex);
        if (endIndex < 0) {
            return line;
        }
        String name = line.substring(startIndex + 2, endIndex);
        String replacement = AceEditor.readContent(name, false, null);
        if ((endIndex += 3) > line.length()) {
            endIndex = line.length();
        }
        return line.substring(0, startIndex) + replacement + line.substring(endIndex);
    }

    public AceReplaceHandler getReplaceHandler() {
        return this.replaceHandler;
    }
}

