/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.jdbc.impl;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.xml.bind.JAXBException;
import org.bridje.ioc.Component;
import org.bridje.ioc.PostConstruct;
import org.bridje.jdbc.JdbcService;
import org.bridje.jdbc.config.DataSourceConfig;
import org.bridje.jdbc.config.JdbcConfig;
import org.bridje.jdbc.impl.DataSourceImpl;
import org.bridje.vfs.VFile;
import org.bridje.vfs.VFileInputStream;

@Component
class JdbcServiceImpl
implements JdbcService {
    private static final Logger LOG = Logger.getLogger(JdbcServiceImpl.class.getName());
    private Map<String, DataSourceImpl> dsMap;
    private Map<String, DataSourceImpl> schemaMap;
    private JdbcConfig config;

    JdbcServiceImpl() {
    }

    @PostConstruct
    public void init() {
        try {
            this.dsMap = new ConcurrentHashMap<String, DataSourceImpl>();
            this.schemaMap = new ConcurrentHashMap<String, DataSourceImpl>();
            this.config = this.loadDefConfig();
            this.config.getDataSources().forEach(cfg -> this.dsMap.put(cfg.getName(), new DataSourceImpl((DataSourceConfig)cfg)));
            this.config.getSchemas().forEach(cfg -> this.schemaMap.put(cfg.getName(), this.dsMap.get(cfg.getDataSource())));
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public DataSource getDataSourceBySchema(String schemaName) {
        DataSource result = this.schemaMap.get(schemaName);
        if (result == null) {
            LOG.log(Level.WARNING, String.format("Could not find the DataSource for the schema %s.", schemaName));
        }
        return result;
    }

    @Override
    public DataSource getDataSource(String name) {
        DataSource result = this.dsMap.get(name);
        if (result == null) {
            LOG.log(Level.WARNING, String.format("The DataSource %s does not exists.", name));
        }
        return result;
    }

    @Override
    public DataSource createDataSource(DataSourceConfig config) {
        return new DataSourceImpl(config);
    }

    @Override
    public void closeDataSource(DataSource dataSource) throws SQLException {
        if (!(dataSource instanceof DataSourceImpl)) {
            throw new IllegalArgumentException("Invalid Data Source.");
        }
        ((DataSourceImpl)dataSource).close();
    }

    @Override
    public void closeAllDataSource() {
        for (Map.Entry<String, DataSourceImpl> entry : this.dsMap.entrySet()) {
            try {
                DataSourceImpl dataSource = entry.getValue();
                dataSource.close();
            }
            catch (SQLException ex) {
                LOG.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        this.dsMap.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JdbcConfig loadDefConfig() throws IOException {
        VFile configFile = new VFile("/etc/jdbc.xml");
        if (!configFile.exists()) return new JdbcConfig();
        try (VFileInputStream is = new VFileInputStream(configFile);){
            JdbcConfig jdbcConfig = JdbcConfig.load((InputStream)is);
            return jdbcConfig;
        }
        catch (JAXBException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return new JdbcConfig();
    }

    @Override
    public void reconnectAll(JdbcConfig config) {
        if (config != null) {
            this.config = config;
        }
        this.config.getDataSources().forEach(cfg -> this.dsMap.get(cfg.getName()).reconnect((DataSourceConfig)cfg));
    }
}

