/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.jdbc.impl;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.bridje.jdbc.config.DataSourceConfig;
import org.bridje.jdbc.impl.ConnectionImpl;

class DataSourceImpl
implements DataSource {
    private static final Logger LOG = Logger.getLogger(DataSourceImpl.class.getName());
    private final Deque<ConnectionImpl> freeConnections = new ConcurrentLinkedDeque<ConnectionImpl>();
    private final Deque<ConnectionImpl> usedConnections = new ConcurrentLinkedDeque<ConnectionImpl>();
    private final DataSourceConfig config;
    private PrintWriter logWriter;
    private int loginTimeout;
    private boolean closed;
    private long lastCheck;

    public DataSourceImpl(DataSourceConfig config) {
        this.config = config;
        this.lastCheck = System.currentTimeMillis();
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.closed) {
            throw new SQLException("The DataSource is close.");
        }
        Connection result = this.getFreeConnection();
        if (result != null) {
            this.checkIdleConnections();
            return result;
        }
        result = this.getNewConnection();
        if (result != null) {
            return result;
        }
        return this.waitFreeConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (this.closed) {
            throw new SQLException("The DataSource is close.");
        }
        return this.createNewConnection(username, password);
    }

    private synchronized Connection getFreeConnection() throws SQLException {
        if (!this.freeConnections.isEmpty()) {
            ConnectionImpl nextConnection = this.freeConnections.poll();
            if (this.needToReconnect(nextConnection) && !nextConnection.isValid(10)) {
                nextConnection.realClose();
                nextConnection = this.createNewConnection();
            }
            nextConnection.open();
            this.usedConnections.add(nextConnection);
            LOG.log(Level.FINE, "Current free connections in {0}: {1}", new Object[]{this.config.getName(), this.freeConnections.size()});
            return nextConnection;
        }
        return null;
    }

    private synchronized Connection getNewConnection() throws SQLException {
        if (this.usedConnections.size() < this.config.getMaxConnections()) {
            ConnectionImpl newConnection = this.createNewConnection();
            newConnection.open();
            this.usedConnections.add(newConnection);
            LOG.log(Level.FINE, "Current used connections in {0}: {1}", new Object[]{this.config.getName(), this.usedConnections.size()});
            return newConnection;
        }
        return null;
    }

    private synchronized Connection waitFreeConnection() throws SQLException {
        Connection cnn = null;
        while (cnn == null) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                LOG.log(Level.SEVERE, ex.getMessage(), ex);
            }
            cnn = this.getFreeConnection();
        }
        return cnn;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    private ConnectionImpl createNewConnection() throws SQLException {
        LOG.log(Level.INFO, "Creating new connection for {0}.", this.config.getName());
        try {
            Class.forName(this.config.getDriver());
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
        Connection internalConnection = DriverManager.getConnection(this.config.getUrl(), this.config.getUser(), this.config.getPassword());
        return new ConnectionImpl(internalConnection, this);
    }

    private Connection createNewConnection(String user, String password) throws SQLException {
        try {
            Class.forName(this.config.getDriver());
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
        return DriverManager.getConnection(this.config.getUrl(), user, password);
    }

    protected synchronized void connectionClosed(ConnectionImpl closedConnection) {
        this.usedConnections.remove(closedConnection);
        this.freeConnections.add(closedConnection);
        LOG.log(Level.FINE, "Current free connections in {0}: {1}", new Object[]{this.config.getName(), this.freeConnections.size()});
        this.notify();
    }

    protected synchronized void close() throws SQLException {
        this.closed = true;
        while (!this.usedConnections.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                LOG.log(Level.FINE, e.getMessage(), e);
            }
        }
        for (ConnectionImpl freeConnection : this.freeConnections) {
            freeConnection.realClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIdleConnections() {
        long idleTime = this.config.getIdleTime() * 1000L;
        if (System.currentTimeMillis() - this.lastCheck > idleTime) {
            DataSourceImpl dataSourceImpl = this;
            synchronized (dataSourceImpl) {
                this.lastCheck = System.currentTimeMillis();
                ArrayList<ConnectionImpl> toRemove = new ArrayList<ConnectionImpl>();
                for (ConnectionImpl freeConnection : this.freeConnections) {
                    if (System.currentTimeMillis() - freeConnection.getLastUse() <= idleTime) continue;
                    try {
                        int totalConnections = this.freeConnections.size() + this.usedConnections.size();
                        if (totalConnections - toRemove.size() <= this.config.getMinConnections()) break;
                        freeConnection.realClose();
                        toRemove.add(freeConnection);
                    }
                    catch (SQLException ex) {
                        LOG.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
                LOG.log(Level.FINE, "Removing {0} connections for {1}.", new Object[]{toRemove.size(), this.config.getName()});
                this.freeConnections.removeAll(toRemove);
                LOG.log(Level.FINE, "Current total connections in {0}: {1}", new Object[]{this.config.getName(), this.freeConnections.size() + this.usedConnections.size()});
            }
        }
    }

    private boolean needToReconnect(ConnectionImpl connection) {
        long timePass;
        long reTime = this.config.getReconnectTime() * 1000;
        return reTime < (timePass = System.currentTimeMillis() - connection.getLastUse());
    }
}

