/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.jdbc.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.bridje.jdbc.config.DataSourceConfig;
import org.bridje.vfs.VFile;
import org.bridje.vfs.VFileInputStream;

@XmlRootElement(name="jdbc")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JdbcConfig {
    @XmlElementWrapper(name="datasources")
    @XmlElements(value={@XmlElement(name="datasource", type=DataSourceConfig.class)})
    private List<DataSourceConfig> dataSources;

    public List<DataSourceConfig> getDataSources() {
        if (this.dataSources == null) {
            this.dataSources = new ArrayList<DataSourceConfig>();
        }
        return this.dataSources;
    }

    public void setDataSources(List<DataSourceConfig> dataSources) {
        this.dataSources = dataSources;
    }

    public static JdbcConfig load(VFile xmlFile) throws JAXBException, IOException {
        if (!xmlFile.exists()) {
            return null;
        }
        try (VFileInputStream is = new VFileInputStream(xmlFile);){
            JdbcConfig jdbcConfig = JdbcConfig.load((InputStream)is);
            return jdbcConfig;
        }
    }

    public static JdbcConfig load(InputStream is) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{JdbcConfig.class});
        return (JdbcConfig)ctx.createUnmarshaller().unmarshal(is);
    }

    public static void save(OutputStream os, JdbcConfig object) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{JdbcConfig.class});
        ctx.createMarshaller().marshal((Object)object, os);
    }
}

