/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.jdbc.impl;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import javax.xml.bind.JAXBException;
import org.bridje.ioc.Component;
import org.bridje.jdbc.JdbcService;
import org.bridje.jdbc.config.DataSourceConfig;
import org.bridje.jdbc.config.JdbcConfig;
import org.bridje.jdbc.impl.DataSourceImpl;
import org.bridje.vfs.VFile;
import org.bridje.vfs.VFileInputStream;

@Component
class JdbcServiceImpl
implements JdbcService {
    private static final Logger LOG = Logger.getLogger(JdbcServiceImpl.class.getName());
    private Map<String, DataSourceImpl> dsMap;
    private JdbcConfig config;

    JdbcServiceImpl() {
    }

    @PostConstruct
    public void init() {
        try {
            this.dsMap = new ConcurrentHashMap<String, DataSourceImpl>();
            this.initConfig();
            this.config.getDataSources().stream().forEach(cfg -> this.dsMap.put(cfg.getName(), new DataSourceImpl((DataSourceConfig)cfg)));
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public DataSource getDataSource(String name) {
        return this.dsMap.get(name);
    }

    @Override
    public DataSource createDataSource(DataSourceConfig config) {
        return new DataSourceImpl(config);
    }

    @Override
    public void closeDataSource(DataSource dataSource) throws SQLException {
        if (!(dataSource instanceof DataSourceImpl)) {
            throw new IllegalArgumentException("Invalid Data Source.");
        }
        ((DataSourceImpl)dataSource).close();
    }

    @Override
    public void closeAllDataSource() {
        for (Map.Entry<String, DataSourceImpl> entry : this.dsMap.entrySet()) {
            try {
                DataSourceImpl dataSource = entry.getValue();
                dataSource.close();
            }
            catch (SQLException ex) {
                LOG.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        this.dsMap.clear();
    }

    private void initConfig() throws IOException {
        VFile configFile = new VFile("/etc/jdbc.xml");
        if (configFile.exists()) {
            try (VFileInputStream is = new VFileInputStream(configFile);){
                this.config = JdbcConfig.load((InputStream)is);
            }
            catch (JAXBException ex) {
                LOG.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        if (this.config == null) {
            this.config = new JdbcConfig();
        }
    }
}

