/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.ioc.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridje.ioc.impl.ClassSet;
import org.bridje.ioc.impl.ContextImpl;

class ClassSetLoader {
    private static final Logger LOG = Logger.getLogger(ClassSetLoader.class.getName());
    private static ClassSetLoader INSTANCE;
    private final Map<Class<?>, ClassSet> clsCache = new ConcurrentHashMap();
    private Map<String, String> propFilesCache;

    public static ClassSetLoader instance() {
        if (INSTANCE == null) {
            INSTANCE = new ClassSetLoader();
        }
        return INSTANCE;
    }

    private ClassSetLoader() {
    }

    public ClassSet findByScope(Class<?> scope) {
        if (this.clsCache.containsKey(scope)) {
            return this.clsCache.get(scope);
        }
        return this.loadScope(scope);
    }

    private ClassSet loadFromClassPath(Class<?> scope) throws IOException {
        HashSet clsList = new HashSet();
        clsList.add(ContextImpl.class);
        clsList.add(scope);
        if (this.propFilesCache == null) {
            this.propFilesCache = this.loadPropFilesCache();
        }
        this.propFilesCache.forEach((clsName, compScope) -> {
            if (compScope != null && scope.getName().equalsIgnoreCase((String)compScope)) {
                try {
                    clsList.add(Class.forName(clsName));
                }
                catch (ClassNotFoundException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        });
        if (clsList.isEmpty()) {
            return null;
        }
        return new ClassSet(clsList);
    }

    private Map<String, String> loadPropFilesCache() throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        Set<String> files = this.findComponentsFiles();
        for (String file : files) {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(file);
            while (resources.hasMoreElements()) {
                URL nextElement = resources.nextElement();
                Properties prop = new Properties();
                try (InputStream is = nextElement.openStream();){
                    prop.load(is);
                }
                prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                    String clsName = (String)key;
                    String compScope = (String)value;
                    result.put(clsName, compScope);
                }));
            }
        }
        return result;
    }

    private synchronized ClassSet loadScope(Class<?> scope) {
        try {
            if (this.clsCache.containsKey(scope)) {
                return this.clsCache.get(scope);
            }
            ClassSet result = this.loadFromClassPath(scope);
            if (result != null) {
                this.clsCache.put(scope, result);
                return result;
            }
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return null;
    }

    private Set<String> findComponentsFiles() {
        HashSet<String> result = new HashSet<String>();
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("BRIDJE-INF/");
            while (resources.hasMoreElements()) {
                URL dirURL = resources.nextElement();
                if (dirURL == null) continue;
                if (dirURL.getProtocol().equals("file")) {
                    this.findComponentsFilesFromDir(dirURL, result);
                    continue;
                }
                if (!dirURL.getProtocol().equals("jar")) continue;
                this.findComponentsFilesFromJar(dirURL, result);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        return result;
    }

    private void findComponentsFilesFromDir(URL dirURL, Set<String> result) throws IOException {
        try {
            File f = new File(dirURL.toURI());
            if (f.isDirectory()) {
                Files.find(f.toPath(), Integer.MAX_VALUE, (t, u) -> t.getFileName().toString().endsWith("ioc-components.properties"), new FileVisitOption[0]).forEach(path -> {
                    int lastIndex = path.toString().lastIndexOf("BRIDJE-INF");
                    String name = path.toString().substring(lastIndex);
                    result.add(name);
                });
            }
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void findComponentsFilesFromJar(URL dirURL, Set<String> result) throws IOException {
        String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
        try {
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName().trim();
                if (!name.endsWith("/ioc-components.properties")) continue;
                result.add(name);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

