/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.ioc.impl;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bridje.ioc.IocContext;
import org.bridje.ioc.impl.ClassSet;
import org.bridje.ioc.impl.ClassUtils;

class ServiceMap {
    private static final Map<Class<?>, ServiceMap> SERVICES_MAP = new ConcurrentHashMap();
    private final Map<Type, List<Class<?>>> map;
    private final Map<Class<?>, List<Type>> compMap;

    public ServiceMap(ClassSet clsSet) {
        HashMap servMap = new HashMap();
        HashMap compsMap = new HashMap();
        if (clsSet != null) {
            for (Class<?> component : clsSet) {
                List<Type> services = ServiceMap.findServices(component);
                compsMap.put(component, services);
                services.stream().forEach(service -> ServiceMap.addComponentToService(servMap, service, component));
            }
        }
        servMap.values().stream().forEach(value -> ClassUtils.sort(value));
        this.map = servMap;
        this.compMap = compsMap;
    }

    public Class<?> findOne(Type service) {
        return this.findOne(service, null);
    }

    public Class<?> findOne(Type service, Integer priority) {
        if (ClassUtils.rawClass(service).equals(IocContext.class)) {
            return this.map.get(ClassUtils.rawClass(service)).get(0);
        }
        List<Class<?>> lst = this.map.get(service);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        if (priority == null) {
            return lst.get(0);
        }
        for (Class<?> cls : lst) {
            int v1 = ClassUtils.findPriority(cls);
            if (v1 <= priority && v1 != Integer.MAX_VALUE) continue;
            return cls;
        }
        return null;
    }

    public boolean exists(Type service) {
        return this.map.containsKey(service);
    }

    public List<Class<?>> findAll(Type service) {
        Type realService = service;
        if (service instanceof WildcardType) {
            realService = ClassUtils.typeOf((WildcardType)service);
        }
        if (realService != null) {
            List<Class<?>> result = this.map.get(realService);
            if (result == null) {
                return null;
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.EMPTY_LIST;
    }

    public static ServiceMap findByScope(Class<?> scope) {
        if (!SERVICES_MAP.containsKey(scope)) {
            ClassSet classSet = ClassSet.findByScope(scope);
            if (classSet != null) {
                ServiceMap result = new ServiceMap(classSet);
                SERVICES_MAP.put(scope, result);
                return result;
            }
            return null;
        }
        return SERVICES_MAP.get(scope);
    }

    public List<Type> getServices(Class<?> component) {
        return this.compMap.get(component);
    }

    private static List<Type> findServices(Class<?> component) {
        ArrayList<Type> result = new ArrayList<Type>();
        result.add((Type)((Object)Object.class));
        result.add(component);
        ServiceMap.fillServicesSuperClasses(component, result);
        ServiceMap.fillServicesIntefaces(component, result);
        return result;
    }

    private static void fillServicesSuperClasses(Class<?> component, List<Type> servicesList) {
        Type supClass = component.getGenericSuperclass();
        while (supClass != null && supClass != Object.class) {
            if (!ClassUtils.hasGenericDeclaration(supClass) && !servicesList.contains(supClass)) {
                servicesList.add(supClass);
            }
            Class cls = ClassUtils.rawClass(supClass);
            servicesList.add(cls);
            ServiceMap.fillServicesIntefaces(cls, servicesList);
            if (cls != null) {
                supClass = cls.getGenericSuperclass();
                continue;
            }
            supClass = null;
        }
    }

    private static void fillServicesIntefaces(Class<?> cls, List<Type> servicesList) {
        Type[] interfaces;
        for (Type ifc : interfaces = cls.getGenericInterfaces()) {
            if (!ClassUtils.hasGenericDeclaration(ifc) && !servicesList.contains(ifc)) {
                servicesList.add(ifc);
            }
            Class icfCls = ClassUtils.rawClass(ifc);
            servicesList.add(icfCls);
            if (icfCls == null) continue;
            ServiceMap.fillServicesIntefaces(icfCls, servicesList);
        }
    }

    private static void addComponentToService(Map<Type, List<Class<?>>> servMap, Type service, Class<?> component) {
        List<Class<?>> components = servMap.get(service);
        if (components == null) {
            components = new ArrayList();
            servMap.put(service, components);
        }
        if (!components.contains(component)) {
            components.add(component);
        }
    }
}

