/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.ioc.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.bridje.ioc.Inject;
import org.bridje.ioc.InjectNext;
import org.bridje.ioc.PostConstruct;

class ClassCache {
    private final List<Field> injectFields;
    private final Constructor constructor;
    private final List<Method> postConstructs;

    public ClassCache(Class<?> cls) {
        this.injectFields = this.createInjectFields(cls);
        this.constructor = this.findConstructor(cls);
        this.postConstructs = this.findPostConstructs(cls);
    }

    public List<Field> getInjectFields() {
        return this.injectFields;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public List<Method> getPostConstructs() {
        return this.postConstructs;
    }

    private List<Field> createInjectFields(Class<?> cls) {
        Field[] declaredFields;
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : declaredFields = cls.getDeclaredFields()) {
            field.setAccessible(true);
            Inject annotation = field.getAnnotation(Inject.class);
            InjectNext annotationNext = field.getAnnotation(InjectNext.class);
            if (annotation != null) {
                result.add(field);
                continue;
            }
            if (annotationNext == null) continue;
            result.add(field);
        }
        return result;
    }

    private Constructor findConstructor(Class<?> cls) {
        for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            constructor.setAccessible(true);
            return constructor;
        }
        return null;
    }

    private List<Method> findPostConstructs(Class<?> cls) {
        Method[] methods;
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : methods = cls.getDeclaredMethods()) {
            PostConstruct annotation = method.getAnnotation(PostConstruct.class);
            if (annotation == null) continue;
            method.setAccessible(true);
            result.add(method);
        }
        return result;
    }
}

