/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.ioc.thls.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ThreadLocalStorage {
    private final ThreadLocal<Map<Class, List<Object>>> threadLocalStorage = new ThreadLocal();

    public <T> T get(Class<T> cls) {
        List<Object> objects;
        Map<Class, List<Object>> map = this.threadLocalStorage.get();
        if (map != null && (objects = map.get(cls)) != null && !objects.isEmpty()) {
            return (T)objects.get(objects.size() - 1);
        }
        return null;
    }

    public <T> void pop(Class<T> cls) {
        List<Object> objects;
        Map<Class, List<Object>> map = this.threadLocalStorage.get();
        if (map != null && (objects = map.get(cls)) != null && !objects.isEmpty()) {
            objects.remove(objects.size() - 1);
        }
    }

    public <T> void put(Class<T> cls, T obj) {
        List<Object> objects;
        Map<Class, List<Object>> map = this.threadLocalStorage.get();
        if (map == null) {
            map = new HashMap<Class, List<Object>>();
            this.threadLocalStorage.set(map);
        }
        if ((objects = map.get(cls)) == null) {
            objects = new ArrayList<Object>();
            map.put(cls, objects);
        }
        objects.add(obj);
    }
}

