/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.ioc.impl;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bridje.ioc.Application;
import org.bridje.ioc.ClassRepository;
import org.bridje.ioc.IocContext;
import org.bridje.ioc.Scope;
import org.bridje.ioc.impl.ClassCache;
import org.bridje.ioc.impl.ClassSet;
import org.bridje.ioc.impl.ClassUtils;
import org.bridje.ioc.impl.Container;
import org.bridje.ioc.impl.GlobalCache;
import org.bridje.ioc.impl.Instanciator;
import org.bridje.ioc.impl.ScopeCache;
import org.bridje.ioc.impl.ServiceMap;

final class ContextImpl<S extends Scope>
implements IocContext<S> {
    private static final Logger LOG = Logger.getLogger(ContextImpl.class.getName());
    private final S scope;
    private final ClassSet classSet;
    private final ServiceMap serviceMap;
    private final Container container;
    private final IocContext<?> parent;
    private final ScopeCache cache;

    protected ContextImpl(S scope) throws IOException {
        this(scope, null);
    }

    private ContextImpl(S scope, IocContext<?> parent) throws IOException {
        this.scope = scope;
        this.cache = GlobalCache.instance().getScope(this.getScopeClass());
        this.parent = parent;
        this.classSet = ClassSet.findByScope(this.getScopeClass());
        this.serviceMap = ServiceMap.findByScope(this.getScopeClass());
        Instanciator creator = new Instanciator(this, this.serviceMap);
        this.container = new Container(creator, scope, this);
        creator.injectDependencies(scope.getClass(), scope);
    }

    @Override
    public <T> T find(Class<T> service) {
        T result = this.findInternal(service);
        if (result != null) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.find(service);
        }
        return null;
    }

    @Override
    public <T> T findNext(Class<T> service, int priority) {
        return (T)this.findNextGeneric(service, priority);
    }

    @Override
    public Object findGeneric(Type service) {
        Object result = this.findGenericInternal(service);
        if (result != null) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.findGeneric(service);
        }
        return null;
    }

    @Override
    public Object findNextGeneric(Type service, int priority) {
        Object result = this.findGenericInternal(service, priority);
        if (result != null) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.findNextGeneric(service, priority);
        }
        return null;
    }

    @Override
    public <T> T[] findAll(Class<T> service) {
        T[] result = this.findAllInternal(service);
        if (result != null && result.length > 0) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.findAll(service);
        }
        return result;
    }

    @Override
    public boolean existsComponent(Class cls) {
        if (this.classSet.contains(cls)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.existsComponent(cls);
        }
        return false;
    }

    @Override
    public boolean exists(Type service) {
        Type type;
        if (ClassUtils.isMultiple(service) ? this.serviceMap.exists(type = ClassUtils.multipleType(service)) : this.serviceMap.exists(service)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.exists(service);
        }
        return false;
    }

    @Override
    public IocContext getParent() {
        return this.parent;
    }

    @Override
    public <T extends Scope> IocContext<T> createChild(T scope) {
        if (scope == null || scope.getClass().equals(Object.class) || scope.getClass().equals(Application.class)) {
            throw new IllegalArgumentException("scope");
        }
        try {
            return new ContextImpl<T>(scope, this);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    private <T> T findInternal(Class<T> service) {
        if (service.isArray()) {
            return (T)this.findGenericInternal(service);
        }
        Class<?> component = this.serviceMap.findOne(service);
        if (component != null) {
            return (T)this.container.create(component);
        }
        return null;
    }

    private <T> T[] findAllInternal(Class<T> service) {
        List<Class<?>> components = this.serviceMap.findAll(service);
        if (components != null) {
            List<Object> resultList = components.stream().map(component -> this.container.create(component)).filter(compInstance -> compInstance != null).collect(Collectors.toList());
            Object[] result = (Object[])Array.newInstance(service, components.size());
            return resultList.toArray(result);
        }
        return (Object[])Array.newInstance(service, 0);
    }

    private Object findGenericInternal(Type service) {
        return this.findGenericInternal(service, null);
    }

    private Object findGenericInternal(Type service, Integer priority) {
        if (ClassUtils.isMultiple(service)) {
            Type type = ClassUtils.multipleType(service);
            Object[] data = this.findAllGenericInternal(type);
            return ClassUtils.createMultiple(service, data);
        }
        return this.findOneGenericInternal(service, priority);
    }

    private Object findOneGenericInternal(Type service, Integer priority) {
        Class<?> component = this.serviceMap.findOne(service, priority);
        if (component != null) {
            return this.container.create(component);
        }
        return null;
    }

    private Object[] findAllGenericInternal(Type service) {
        Object[] result;
        if (ClassUtils.isMultiple(service)) {
            return null;
        }
        Class resultClass = ClassUtils.rawClass(service);
        if (resultClass == null) {
            return null;
        }
        List<Class<?>> components = this.serviceMap.findAll(service);
        if (components != null) {
            List<Object> resultList = components.stream().map(component -> this.container.create(component)).filter(compInstance -> compInstance != null).collect(Collectors.toList());
            result = (Object[])Array.newInstance(resultClass, resultList.size());
            result = resultList.toArray(result);
        } else {
            result = (Object[])Array.newInstance(resultClass, 0);
        }
        return result;
    }

    @Override
    public ClassRepository getClassRepository() {
        return this.classSet;
    }

    @Override
    public Class<S> getScopeClass() {
        return this.scope.getClass();
    }

    @Override
    public S getScope() {
        return this.scope;
    }

    public String toString() {
        return "IocContext: " + this.scope;
    }

    public ClassCache findCache(Class<?> cls) {
        return this.cache.getCache(cls);
    }
}

