/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.ioc.impl;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bridje.ioc.impl.ClassSet;
import org.bridje.ioc.impl.ClassUtils;

class ServiceMap {
    private static Map<String, ServiceMap> serviceMapCache;
    private final Map<Type, List<Class<?>>> map = new HashMap();
    private final Map<Class<?>, List<Type>> compMap = new HashMap();

    public ServiceMap(ServiceMap baseMap, ClassSet list) {
        if (baseMap != null) {
            this.map.putAll(baseMap.map);
            this.compMap.putAll(baseMap.compMap);
        }
        if (list != null) {
            for (Class clazz : list) {
                List<Type> services = ServiceMap.findServices(clazz);
                this.compMap.put(clazz, services);
                for (Type service : services) {
                    this.addComponentToService(service, clazz);
                }
            }
        }
        for (List list2 : this.map.values()) {
            ClassUtils.sort(list2);
        }
    }

    public Class<?> findOne(Type service) {
        return this.findOne(service, null);
    }

    public Class<?> findOne(Type service, Integer priority) {
        List<Class<?>> lst = this.map.get(service);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        if (priority == null) {
            return lst.get(0);
        }
        for (Class<?> cls : lst) {
            int v1 = ClassUtils.findPriority(cls);
            if (v1 <= priority && v1 != Integer.MAX_VALUE) continue;
            return cls;
        }
        return null;
    }

    public boolean exists(Type service) {
        return this.map.containsKey(service);
    }

    public List<Class<?>> findAll(Type service) {
        if (service instanceof WildcardType) {
            service = ClassUtils.typeOf((WildcardType)service);
        }
        if (service != null) {
            List<Class<?>> result = this.map.get(service);
            if (result == null) {
                return null;
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.EMPTY_LIST;
    }

    public static ServiceMap findByScope(String scope) {
        if (serviceMapCache == null) {
            serviceMapCache = new ConcurrentHashMap<String, ServiceMap>();
        }
        if (!serviceMapCache.containsKey(scope)) {
            ClassSet classSet = ClassSet.findByScope(scope);
            if (classSet != null) {
                ServiceMap result = new ServiceMap(null, classSet);
                serviceMapCache.put(scope, result);
                return result;
            }
            return null;
        }
        return serviceMapCache.get(scope);
    }

    public List<Type> getServices(Class<?> component) {
        return this.compMap.get(component);
    }

    private static List<Type> findServices(Class<?> component) {
        ArrayList<Type> result = new ArrayList<Type>();
        result.add((Type)((Object)Object.class));
        result.add(component);
        ServiceMap.fillServicesSuperClasses(component, result);
        ServiceMap.fillServicesIntefaces(component, result);
        return result;
    }

    private static void fillServicesSuperClasses(Class<?> component, List<Type> servicesList) {
        Type supClass = component.getGenericSuperclass();
        while (supClass != null && supClass != Object.class) {
            if (!ClassUtils.hasGenericDeclaration(supClass) && !servicesList.contains(supClass)) {
                servicesList.add(supClass);
            }
            Class cls = ClassUtils.rawClass(supClass);
            servicesList.add(cls);
            ServiceMap.fillServicesIntefaces(cls, servicesList);
            if (cls != null) {
                supClass = cls.getGenericSuperclass();
                continue;
            }
            supClass = null;
        }
    }

    private static void fillServicesIntefaces(Class<?> cls, List<Type> servicesList) {
        Type[] interfaces;
        for (Type ifc : interfaces = cls.getGenericInterfaces()) {
            if (!ClassUtils.hasGenericDeclaration(ifc) && !servicesList.contains(ifc)) {
                servicesList.add(ifc);
            }
            Class icfCls = ClassUtils.rawClass(ifc);
            servicesList.add(icfCls);
            if (icfCls == null) continue;
            ServiceMap.fillServicesIntefaces(icfCls, servicesList);
        }
    }

    private void addComponentToService(Type service, Class<?> component) {
        List<Class<?>> components = this.map.get(service);
        if (components == null) {
            components = new ArrayList();
            this.map.put(service, components);
        }
        if (!components.contains(component)) {
            components.add(component);
        }
    }
}

