/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.ioc.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.bridje.ioc.ContextListener;
import org.bridje.ioc.Inject;
import org.bridje.ioc.InjectNext;
import org.bridje.ioc.IocContext;
import org.bridje.ioc.impl.ClassUtils;
import org.bridje.ioc.impl.ServiceMap;

class Instanciator {
    private static final Logger LOG = Logger.getLogger(Instanciator.class.getName());
    private final IocContext context;
    private final ServiceMap serviceMap;
    private ContextListener[] contextListeners;

    public Instanciator(IocContext context, ServiceMap serviceMap) {
        this.context = context;
        this.serviceMap = serviceMap;
    }

    public <T> T instantiate(Class<T> cls) {
        try {
            Constructor<?> constructor = this.findDefaultConstructor(cls);
            if (constructor == null) {
                return null;
            }
            constructor.setAccessible(true);
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            LOG.warning(ex.getMessage());
            return null;
        }
    }

    public void callPostConstruct(Class cls, Object obj) {
        Method[] declaredMethods;
        for (Method declaredMethod : declaredMethods = cls.getDeclaredMethods()) {
            PostConstruct annotation = declaredMethod.getAnnotation(PostConstruct.class);
            if (annotation == null) continue;
            try {
                declaredMethod.setAccessible(true);
                declaredMethod.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                LOG.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public void injectDependencies(Class cls, Object obj) {
        Field[] declaredFields;
        for (Field declaredField : declaredFields = cls.getDeclaredFields()) {
            InjectNext annotationNext;
            Inject annotation = declaredField.getAnnotation(Inject.class);
            if (annotation != null) {
                this.injectDependency(cls, obj, declaredField, null);
            }
            if ((annotationNext = declaredField.getAnnotation(InjectNext.class)) == null) continue;
            this.injectDependency(cls, obj, declaredField, ClassUtils.findPriority(cls));
        }
        Class supClass = cls.getSuperclass();
        if (supClass != null && supClass != Object.class) {
            this.injectDependencies(supClass, obj);
        }
    }

    public void injectDependency(Class cls, Object obj, Field field, Integer priority) {
        try {
            Type service = field.getGenericType();
            Object componentObj = priority == null ? this.context.findGeneric(service) : this.context.findNextGeneric(service, priority);
            field.setAccessible(true);
            field.set(obj, componentObj);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private <T> Constructor<?> findDefaultConstructor(Class<T> cls) {
        for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            return constructor;
        }
        return null;
    }

    private void initContextListeners() {
        if (null == this.contextListeners) {
            this.contextListeners = this.context.findAll(ContextListener.class);
        }
    }

    protected <T> void invokePreCreateListener(Class<T> cls) {
        if (ContextListener.class.isAssignableFrom(cls)) {
            return;
        }
        this.initContextListeners();
        if (null != this.contextListeners) {
            block0: for (ContextListener contextListener : this.contextListeners) {
                Type type = this.findGenericType(contextListener.getClass());
                if (type.equals(Object.class)) {
                    contextListener.preCreateComponent(cls);
                    continue;
                }
                List<Type> services = this.serviceMap.getServices(cls);
                if (services == null) continue;
                for (Type service : services) {
                    if (!type.equals(service)) continue;
                    contextListener.preCreateComponent(cls);
                    continue block0;
                }
            }
        }
    }

    public <T> void invokePreInitListener(Class<T> cls, Object instance) {
        if (ContextListener.class.isAssignableFrom(cls)) {
            return;
        }
        this.initContextListeners();
        if (null != this.contextListeners) {
            block0: for (ContextListener contextListener : this.contextListeners) {
                Type type = this.findGenericType(contextListener.getClass());
                if (type.equals(Object.class)) {
                    contextListener.preInitComponent(cls, instance);
                    continue;
                }
                List<Type> services = this.serviceMap.getServices(cls);
                if (services == null) continue;
                for (Type service : services) {
                    if (!type.equals(service)) continue;
                    contextListener.preInitComponent(cls, instance);
                    continue block0;
                }
            }
        }
    }

    public <T> void invokePostInitListener(Class<T> cls, Object instance) {
        if (ContextListener.class.isAssignableFrom(cls)) {
            return;
        }
        this.initContextListeners();
        if (null != this.contextListeners) {
            block0: for (ContextListener contextListener : this.contextListeners) {
                Type type = this.findGenericType(contextListener.getClass());
                if (type.equals(Object.class)) {
                    contextListener.postInitComponent(cls, instance);
                    continue;
                }
                List<Type> services = this.serviceMap.getServices(cls);
                if (services == null) continue;
                for (Type service : services) {
                    if (!type.equals(service)) continue;
                    contextListener.postInitComponent(cls, instance);
                    continue block0;
                }
            }
        }
    }

    private Type findGenericType(Class<? extends ContextListener> clazz) {
        Type type = ((ParameterizedType)clazz.getGenericInterfaces()[0]).getActualTypeArguments()[0];
        return type;
    }
}

