/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.ioc.impl;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridje.ioc.ClassRepository;
import org.bridje.ioc.IocContext;
import org.bridje.ioc.impl.ClassSet;
import org.bridje.ioc.impl.ClassUtils;
import org.bridje.ioc.impl.Container;
import org.bridje.ioc.impl.Instanciator;
import org.bridje.ioc.impl.ServiceMap;

class ContextImpl
implements IocContext {
    private static final Logger LOG = Logger.getLogger(ContextImpl.class.getName());
    private final String scope;
    private final ClassSet classSet;
    private final Instanciator creator;
    private final ServiceMap serviceMap;
    private final Container container;
    private final IocContext parent;

    public ContextImpl() throws IOException {
        this("APPLICATION");
    }

    private ContextImpl(String scope) throws IOException {
        this(scope, null, null);
    }

    private ContextImpl(String scope, Collection instances) throws IOException {
        this(scope, instances, null);
    }

    private ContextImpl(String scope, Collection instances, IocContext parent) throws IOException {
        this.scope = scope;
        this.parent = parent;
        if (instances != null && !instances.isEmpty()) {
            ClassSet cs = new ClassSet(ClassUtils.toClasses(instances));
            this.classSet = new ClassSet(ClassSet.findByScope(scope), cs);
            this.serviceMap = new ServiceMap(ServiceMap.findByScope(scope), cs);
        } else {
            this.classSet = ClassSet.findByScope(scope);
            this.serviceMap = ServiceMap.findByScope(scope);
        }
        this.creator = new Instanciator(this, this.serviceMap);
        ArrayList<ContextImpl> allInstances = new ArrayList<ContextImpl>(instances != null ? instances.size() + 1 : 1);
        allInstances.add(this);
        if (instances != null) {
            allInstances.addAll(instances);
        }
        this.container = new Container(this.creator, allInstances);
    }

    @Override
    public <T> T find(Class<T> service) {
        T result = this.findInternal(service);
        if (result != null) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.find(service);
        }
        return null;
    }

    @Override
    public <T> T findNext(Class<T> service, int priority) {
        return (T)this.findNextGeneric(service, priority);
    }

    @Override
    public Object findGeneric(Type service) {
        Object result = this.findGenericInternal(service);
        if (result != null) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.findGeneric(service);
        }
        return null;
    }

    @Override
    public Object findNextGeneric(Type service, int priority) {
        Object result = this.findGenericInternal(service, priority);
        if (result != null) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.findNextGeneric(service, priority);
        }
        return null;
    }

    @Override
    public <T> T[] findAll(Class<T> service) {
        T[] result = this.findAllInternal(service);
        if (result != null && result.length > 0) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.findAll(service);
        }
        return result;
    }

    @Override
    public boolean existsComponent(Class cls) {
        if (this.classSet.contains(cls)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.existsComponent(cls);
        }
        return false;
    }

    @Override
    public boolean exists(Type service) {
        Type type;
        if (ClassUtils.isMultiple(service) ? this.serviceMap.exists(type = ClassUtils.multipleType(service)) : this.serviceMap.exists(service)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.exists(service);
        }
        return false;
    }

    @Override
    public IocContext getParent() {
        return this.parent;
    }

    @Override
    public IocContext createChild(String scope) {
        return this.createChild(scope, null);
    }

    @Override
    public IocContext createChild(String scope, Collection instances) {
        try {
            return new ContextImpl(scope, instances, this);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    private <T> T findInternal(Class<T> service) {
        if (service.isArray()) {
            return (T)this.findGenericInternal(service);
        }
        Class<?> component = this.serviceMap.findOne(service);
        if (component != null) {
            return (T)this.container.create(component);
        }
        return null;
    }

    private <T> T[] findAllInternal(Class<T> service) {
        List<Class<?>> components = this.serviceMap.findAll(service);
        if (components != null) {
            ArrayList resultList = new ArrayList(components.size());
            for (Class<?> component : components) {
                Object compInstance = this.container.create(component);
                if (compInstance == null) continue;
                resultList.add(compInstance);
            }
            Object[] result = (Object[])Array.newInstance(service, components.size());
            return resultList.toArray(result);
        }
        return (Object[])Array.newInstance(service, 0);
    }

    private Object findGenericInternal(Type service) {
        return this.findGenericInternal(service, null);
    }

    private Object findGenericInternal(Type service, Integer priority) {
        if (ClassUtils.isMultiple(service)) {
            Type type = ClassUtils.multipleType(service);
            Object[] data = this.findAllGenericInternal(type);
            return ClassUtils.createMultiple(service, data);
        }
        return this.findOneGenericInternal(service, priority);
    }

    private Object findOneGenericInternal(Type service, Integer priority) {
        Class<?> component = this.serviceMap.findOne(service, priority);
        if (component != null) {
            return this.container.create(component);
        }
        return null;
    }

    private Object[] findAllGenericInternal(Type service) {
        if (ClassUtils.isMultiple(service)) {
            return null;
        }
        Class resultClass = ClassUtils.rawClass(service);
        if (resultClass == null) {
            return null;
        }
        Object[] result = null;
        List<Class<?>> components = this.serviceMap.findAll(service);
        if (components != null) {
            ArrayList resultList = new ArrayList(components.size());
            for (Class<?> component : components) {
                Object compInstance = this.container.create(component);
                if (compInstance == null) continue;
                resultList.add(compInstance);
            }
            result = (Object[])Array.newInstance(resultClass, components.size());
            result = resultList.toArray(result);
        } else {
            result = (Object[])Array.newInstance(resultClass, 0);
        }
        return result;
    }

    @Override
    public ClassRepository getClassRepository() {
        return this.classSet;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    public String toString() {
        return "IocContext: " + this.scope;
    }
}

