/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.ioc.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bridje.ioc.impl.Instanciator;

class Container {
    private final Map<Class, Object> components = new ConcurrentHashMap<Class, Object>();
    private final Instanciator instanciator;

    public Container(Instanciator creator, List instances) {
        this.instanciator = creator;
        for (Object instance : instances) {
            this.components.put(instance.getClass(), instance);
            this.instanciator.injectDependencies(instance.getClass(), instance);
        }
    }

    public boolean contains(Class cls) {
        return this.components.containsKey(cls);
    }

    public <T> T get(Class<T> cls) {
        return (T)this.components.get(cls);
    }

    public <T> T create(Class<T> cls) {
        if (this.components.containsKey(cls)) {
            return (T)this.components.get(cls);
        }
        this.instanciator.invokePreCreateListener(cls);
        T obj = this.instanciator.instantiate(cls);
        if (obj == null) {
            return null;
        }
        this.components.put(cls, obj);
        this.instanciator.invokePreInitListener(cls, obj);
        this.instanciator.injectDependencies(cls, obj);
        this.instanciator.invokePostInitListener(cls, obj);
        this.instanciator.callPostConstruct(cls, obj);
        return obj;
    }
}

