/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.ioc.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.bridje.ioc.Component;

@SupportedAnnotationTypes(value={"org.bridje.ioc.Component"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ComponentProcessor
extends AbstractProcessor {
    private Filer filer;
    private FileObject fobj;
    private Writer writer;
    private static final Logger LOG = Logger.getLogger(ComponentProcessor.class.getName());
    public static final String COMPONENTS_RESOURCE_FILE = "BRIDJE-INF/ioc/components.properties";

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Messager messager = processingEnv.getMessager();
        try {
            this.filer = processingEnv.getFiler();
            this.fobj = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", COMPONENTS_RESOURCE_FILE, new Element[0]);
            this.writer = this.fobj.openWriter();
        }
        catch (IOException e) {
            messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            LOG.severe(e.getMessage());
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Messager messager = this.processingEnv.getMessager();
        try {
            for (TypeElement typeElement : annotations) {
                Set<? extends Element> ann = roundEnv.getElementsAnnotatedWith(typeElement);
                for (Element element : ann) {
                    if (element.getKind() != ElementKind.CLASS) continue;
                    Component annot = element.getAnnotation(Component.class);
                    String clsName = element.toString();
                    String scope = annot.scope();
                    this.appendClass(clsName, scope);
                }
            }
        }
        catch (IOException ex) {
            messager.printMessage(Diagnostic.Kind.ERROR, ex.getMessage());
            LOG.severe(ex.getMessage());
        }
        return false;
    }

    private void appendClass(String clsName, String scope) throws IOException {
        this.writer.append(clsName);
        this.writer.append("=");
        this.writer.append(scope);
        this.writer.append("\n");
        this.writer.flush();
    }
}

