/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.ioc.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridje.ioc.ClassNavigator;
import org.bridje.ioc.ClassRepository;
import org.bridje.ioc.FieldNavigator;
import org.bridje.ioc.MethodNavigator;
import org.bridje.ioc.impl.ComponentProcessor;
import org.bridje.ioc.impl.ContextImpl;

class ClassSet
implements Iterable<Class<?>>,
ClassRepository {
    private static final Logger LOG = Logger.getLogger(ComponentProcessor.class.getName());
    private static Map<String, ClassSet> classSetCache;
    private static Map<String, String> propFilesCache;
    private final Set<Class<?>> clsSet = new HashSet();

    private ClassSet() {
    }

    public ClassSet(Collection<Class<?>> classes) {
        this();
        if (classes != null && !classes.isEmpty()) {
            this.clsSet.addAll(classes);
        }
    }

    public ClassSet(Class<?> ... classes) {
        this(ClassSet.asList(classes));
    }

    public ClassSet(ClassSet ... lsts) {
        this();
        if (lsts != null && lsts.length > 0) {
            for (ClassSet clst : lsts) {
                if (clst == null || clst.isEmpty()) continue;
                this.clsSet.addAll(clst.clsSet);
            }
        }
    }

    public boolean contains(Class cls) {
        return this.clsSet.contains(cls);
    }

    public boolean isEmpty() {
        return this.clsSet.isEmpty();
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return this.clsSet.iterator();
    }

    public static ClassSet findByScope(String scope) {
        if (classSetCache == null) {
            classSetCache = new ConcurrentHashMap<String, ClassSet>();
        }
        if (classSetCache.containsKey(scope)) {
            return classSetCache.get(scope);
        }
        try {
            ClassSet result = ClassSet.loadFromClassPath(scope);
            if (result != null) {
                classSetCache.put(scope, result);
                return result;
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return null;
    }

    private static ClassSet loadFromClassPath(String scope) throws IOException {
        HashSet clsList = new HashSet();
        clsList.add(ContextImpl.class);
        if (propFilesCache == null) {
            propFilesCache = ClassSet.loadPropFilesCache();
        }
        for (Map.Entry<String, String> entrySet : propFilesCache.entrySet()) {
            String clsName = entrySet.getKey();
            String compScope = entrySet.getValue();
            if (null == compScope || !compScope.equalsIgnoreCase(scope)) continue;
            try {
                clsList.add(Class.forName(clsName));
            }
            catch (ClassNotFoundException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
        if (clsList.isEmpty()) {
            return null;
        }
        return new ClassSet(clsList);
    }

    private static Map<String, String> loadPropFilesCache() throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("BRIDJE-INF/ioc/components.properties");
        while (resources.hasMoreElements()) {
            URL nextElement = resources.nextElement();
            Properties prop = new Properties();
            try (InputStream is = nextElement.openStream();){
                prop.load(is);
            }
            prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                String clsName = (String)key;
                String compScope = (String)value;
                result.put(clsName, compScope);
            }));
        }
        return result;
    }

    public int size() {
        return this.clsSet.size();
    }

    private static Collection<Class<?>> asList(Class<?> ... clss) {
        if (clss == null || clss.length == 0) {
            return null;
        }
        return Arrays.asList(clss);
    }

    @Override
    public <A extends Annotation> void navigateAnnotMethods(Class<A> annotation, MethodNavigator<A> navigator) {
        for (Class<?> cls : this) {
            Method[] methods;
            for (Method method : methods = cls.getDeclaredMethods()) {
                A annInst = method.getAnnotation(annotation);
                if (annInst == null) continue;
                navigator.accept(method, cls, annInst);
            }
        }
    }

    @Override
    public <A extends Annotation> void navigateAnnotFileds(Class<A> annotation, FieldNavigator<A> navigator) {
        for (Class<?> cls : this) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                A annInst = field.getAnnotation(annotation);
                if (annInst == null) continue;
                navigator.accept(field, cls, annInst);
            }
        }
    }

    @Override
    public <A extends Annotation> void navigateAnnotClasses(Class<A> annotation, ClassNavigator<A> navigator) {
        for (Class<?> cls : this) {
            A annot = cls.getAnnotation(annotation);
            if (annot == null) continue;
            navigator.accept(cls, annot);
            break;
        }
    }
}

