/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.el.impl.convert;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.bridje.el.ElSimpleConvertMap;
import org.bridje.el.ElSimpleConvertProvider;
import org.bridje.ioc.Component;
import org.bridje.ioc.Priority;

@Component
@Priority(value=5030)
class DateConverter
implements ElSimpleConvertProvider {
    DateConverter() {
    }

    @Override
    public ElSimpleConvertMap createConvertMap() {
        ElSimpleConvertMap map = new ElSimpleConvertMap();
        map.add(LocalDate.class, Date.class, this::ldToDate);
        map.add(Date.class, LocalDate.class, this::dateToLd);
        map.add(LocalDateTime.class, Date.class, this::ldtToDate);
        map.add(Date.class, LocalDateTime.class, this::dateToLdt);
        return map;
    }

    public Date ldToDate(LocalDate data) {
        return Date.from(data.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public LocalDate dateToLd(Date data) {
        return data.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public Date ldtToDate(LocalDateTime data) {
        return Date.from(data.atZone(ZoneId.systemDefault()).toInstant());
    }

    public LocalDateTime dateToLdt(Date data) {
        return data.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }
}

