/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.el.impl.convert;

import org.bridje.el.ElAdvanceConverter;
import org.bridje.ioc.Component;
import org.bridje.ioc.Priority;

@Component
@Priority(value=5020)
class EnumConverter
implements ElAdvanceConverter {
    EnumConverter() {
    }

    @Override
    public <F, T> boolean canConvert(Class<F> from, Class<T> to) {
        return from == String.class && this.isEnum(to) || to == String.class && this.isEnum(from) || this.isOrdinal(from) && this.isEnum(to) || this.isOrdinal(to) && this.isEnum(from);
    }

    @Override
    public <T> T convert(Object value, Class<T> type) {
        if (type == String.class) {
            return (T)this.toString((Enum)value);
        }
        if (this.isOrdinal(type)) {
            return (T)this.toOrdinal((Enum)value);
        }
        if (this.isEnum(type)) {
            if (value instanceof String) {
                return (T)this.fromString((String)value, type);
            }
            return (T)this.fromOrdinal((Integer)value, type);
        }
        return null;
    }

    private String toString(Enum enumValue) {
        return enumValue.name();
    }

    private Enum fromString(String string, Class<Enum> enumCls) {
        return Enum.valueOf(enumCls, string);
    }

    private Integer toOrdinal(Enum value) {
        return value.ordinal();
    }

    private Enum fromOrdinal(Integer ordinal, Class<Enum> enumCls) {
        Enum[] enumConst = enumCls.getEnumConstants();
        if (ordinal >= 0 && ordinal < enumConst.length) {
            return enumConst[ordinal];
        }
        return null;
    }

    private <T> boolean isEnum(Class<T> cls) {
        return cls.isEnum();
    }

    private <F> boolean isOrdinal(Class<F> cls) {
        return cls == Integer.class || cls == Integer.TYPE;
    }
}

