/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.el.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import org.bridje.el.ElEnvironment;
import org.bridje.el.impl.ExpressionFactoryImpl;
import org.bridje.el.impl.IocElContext;
import org.bridje.ioc.Ioc;
import org.bridje.ioc.IocContext;

class IocEnviromentImpl
implements ElEnvironment {
    private static final Logger LOG = Logger.getLogger(IocEnviromentImpl.class.getName());
    private final IocElContext context;
    private final ExpressionFactory factory = (ExpressionFactory)Ioc.context().find(ExpressionFactoryImpl.class);
    private final Map<String, Stack<ValueExpression>> varsStack;

    public IocEnviromentImpl(IocContext context) {
        this.context = new IocElContext(context, this.factory);
        this.varsStack = new HashMap<String, Stack<ValueExpression>>();
    }

    @Override
    public <T> T get(String expression, Class<T> resultCls) {
        ValueExpression valueExp = this.factory.createValueExpression((ELContext)this.context, expression, resultCls);
        return (T)valueExp.getValue((ELContext)this.context);
    }

    @Override
    public <T> void set(String expression, T value) {
        Class cls = Object.class;
        if (value != null) {
            cls = value.getClass();
        }
        ValueExpression valueExp = this.factory.createValueExpression((ELContext)this.context, expression, cls);
        try {
            valueExp.setValue((ELContext)this.context, value);
        }
        catch (PropertyNotFoundException e) {
            LOG.log(Level.WARNING, e.getMessage());
        }
    }

    @Override
    public <T> void pushVar(String name, T value) {
        Stack<Object> stack = this.varsStack.get(name);
        if (stack == null) {
            stack = new Stack();
            this.varsStack.put(name, stack);
        }
        ValueExpression exp = null;
        if (value != null) {
            exp = this.factory.createValueExpression(value, value.getClass());
        }
        stack.push(exp);
        this.context.setVariable(name, exp);
    }

    @Override
    public void popVar(String name) {
        Stack<ValueExpression> stack = this.varsStack.get(name);
        ValueExpression exp = null;
        if (stack != null) {
            if (!stack.empty()) {
                stack.pop();
            }
            if (!stack.empty()) {
                exp = stack.peek();
            }
            if (stack.empty()) {
                this.varsStack.remove(name);
            }
        }
        this.context.setVariable(name, exp);
    }

    @Override
    public <T> T getVar(String name, Class<T> resultCls) {
        if (!this.varExists(name)) {
            return null;
        }
        return this.get("${" + name + "}", resultCls);
    }

    @Override
    public String getVarAsString(String name) {
        if (!this.varExists(name)) {
            return "";
        }
        return this.get("${" + name + "}", String.class);
    }

    @Override
    public boolean varExists(String name) {
        return this.varsStack.containsKey(name);
    }
}

